/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.util.concurrent.ScheduledExecutorService;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.MemoryInfo;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.util.Clock;

public class DaemonStats {
    private final Clock totalTime;
    private final TimeProvider timeProvider;
    private final MemoryInfo memory;
    private final GarbageCollectionMonitor gcMonitor;
    private int buildCount;
    private long currentBuildStart;
    private long allBuildsTime;
    private int currentPerformance;

    DaemonStats(ScheduledExecutorService scheduledExecutorService) {
        this(new Clock(), new TrueTimeProvider(), new MemoryInfo(), new GarbageCollectionMonitor(scheduledExecutorService));
    }

    public DaemonStats(Clock totalTime, TimeProvider timeProvider, MemoryInfo memory, GarbageCollectionMonitor gcMonitor) {
        this.totalTime = totalTime;
        this.timeProvider = timeProvider;
        this.memory = memory;
        this.gcMonitor = gcMonitor;
    }

    void buildStarted() {
        ++this.buildCount;
        this.currentBuildStart = this.timeProvider.getCurrentTime();
    }

    void buildFinished() {
        long buildTime = Math.max(this.timeProvider.getCurrentTime() - this.currentBuildStart, 1L);
        this.allBuildsTime += buildTime;
        this.currentPerformance = DaemonStats.performance(this.allBuildsTime, this.memory);
    }

    private static int performance(long totalTime, MemoryInfo memoryInfo) {
        if (memoryInfo.getCollectionTime() > 0L && memoryInfo.getCollectionTime() < totalTime) {
            return 100 - NumberUtil.percentOf(memoryInfo.getCollectionTime(), totalTime);
        }
        return 100;
    }

    int getCurrentPerformance() {
        return this.currentPerformance;
    }

    String getHealthInfo() {
        if (this.buildCount == 1) {
            return String.format("Starting build in new daemon [memory: %s]", NumberUtil.formatBytes(this.memory.getMaxMemory()));
        }
        String message = String.format("Starting %s build in daemon [uptime: %s, performance: %s%%", NumberUtil.ordinal(this.buildCount), this.totalTime.getTime(), this.getCurrentPerformance());
        if (this.gcMonitor.getGcStrategy() != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            GarbageCollectionStats tenuredStats = this.gcMonitor.getTenuredStats();
            message = tenuredStats.getUsage() > 0 ? message + String.format(", GC rate: %.2f/s, tenured heap usage: %s%% of %s", tenuredStats.getRate(), tenuredStats.getUsage(), NumberUtil.formatBytes(tenuredStats.getMax())) : message + ", no major garbage collections";
        }
        return message + "]";
    }

    GarbageCollectionMonitor getGcMonitor() {
        return this.gcMonitor;
    }
}

