/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JarCache {
    private final Lock lock = new ReentrantLock();
    private final Cache<File, FileInfo> cachedFiles = CacheBuilder.newBuilder().maximumSize(200L).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCachedJar(File original, Factory<File> baseDirFactory) {
        FileInfo fileInfo;
        File source = FileUtils.canonicalize(original);
        this.lock.lock();
        try {
            fileInfo = (FileInfo)this.cachedFiles.getIfPresent((Object)source);
            if (fileInfo == null || !fileInfo.cachedFile.exists()) {
                long lastModified = source.lastModified();
                long length = source.length();
                HashValue hashValue = HashUtil.createHash(source, "sha1");
                fileInfo = this.copyIntoCache(baseDirFactory, source, lastModified, length, hashValue);
            } else {
                HashValue hashValue;
                long lastModified = source.lastModified();
                long length = source.length();
                if (!(lastModified == fileInfo.lastModified && length == fileInfo.length || (hashValue = HashUtil.createHash(source, "sha1")).equals(fileInfo.hashValue))) {
                    fileInfo = this.copyIntoCache(baseDirFactory, source, lastModified, length, hashValue);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return fileInfo.cachedFile;
    }

    private FileInfo copyIntoCache(Factory<File> baseDirFactory, File source, long lastModified, long length, HashValue hashValue) {
        File baseDir = baseDirFactory.create();
        File cachedFile = new File(baseDir, hashValue.asCompactString() + '/' + source.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile(source, cachedFile);
        }
        FileInfo fileInfo = new FileInfo(lastModified, length, hashValue, cachedFile);
        this.cachedFiles.put((Object)source, (Object)fileInfo);
        return fileInfo;
    }

    private static class FileInfo {
        final long lastModified;
        final long length;
        final HashValue hashValue;
        final File cachedFile;

        private FileInfo(long lastModified, long length, HashValue hashValue, File cachedFile) {
            this.lastModified = lastModified;
            this.length = length;
            this.hashValue = hashValue;
            this.cachedFile = cachedFile;
        }
    }
}

