/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.io.Serializable;
import org.gradle.foundation.ipc.basic.ClientProcess;
import org.gradle.internal.UncheckedException;

public class GradleClient {
    private ClientProcess clientProcess;

    public void start(ClientProcess.Protocol protocol) {
        String portText = System.getProperty("PortNumber");
        if (portText == null) {
            throw new RuntimeException("No port number specified. Cannot run client");
        }
        try {
            int port = Integer.parseInt(portText);
            this.start(protocol, port);
        }
        catch (NumberFormatException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void start(ClientProcess.Protocol protocol, int port) {
        this.clientProcess = new ClientProcess(protocol);
        this.clientProcess.start(port);
    }

    public boolean sendMessage(String messageType, String message, Serializable data) {
        return this.clientProcess.sendMessage(messageType, message, data);
    }

    public boolean sendMessage(String messageType, String message) {
        return this.sendMessage(messageType, message, null);
    }

    public void stop() {
        this.clientProcess.stop();
    }
}

