/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.io.File;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.gradle.AbstractGradleServerProtocol;

public class TaskListServerProtocol
extends AbstractGradleServerProtocol {
    private static final String INIT_SCRIPT_NAME = "refresh-tasks-init-script";
    private ExecutionInteraction executionInteraction;

    public TaskListServerProtocol(File currentDirectory, File gradleHomeDirectory, File customGradleExecutor, String fullCommandLine, LogLevel logLevel, ShowStacktrace stackTraceLevel, ExecutionInteraction executionInteraction) {
        super(currentDirectory, gradleHomeDirectory, customGradleExecutor, fullCommandLine, logLevel, stackTraceLevel);
        this.executionInteraction = executionInteraction;
    }

    protected boolean handleMessageReceived(MessageObject message) {
        if ("TaskListCompletedWithErrors".equals(message.getMessageType())) {
            this.setHasReceivedBuildCompleteNotification();
            return true;
        }
        if ("TaskListCompletedSuccessfully".equals(message.getMessageType())) {
            this.setHasReceivedBuildCompleteNotification();
            List projects = (List)((Object)message.getData());
            this.executionInteraction.projectsPopulated(projects);
            return true;
        }
        if ("exiting".equals(message.getMessageType())) {
            this.closeConnection();
            return true;
        }
        return false;
    }

    protected void reportClientExit(boolean wasPremature, int returnCode, String output) {
        this.executionInteraction.reportExecutionFinished(returnCode == 0, output, null);
    }

    protected void addStatus(String status) {
        this.executionInteraction.reportLiveOutput(status);
    }

    public File getInitScriptFile() {
        return this.extractInitScriptFile(TaskListServerProtocol.class, INIT_SCRIPT_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExecutionInteraction {
        public void reportExecutionStarted();

        public void reportExecutionFinished(boolean var1, String var2, Throwable var3);

        public void projectsPopulated(List<ProjectView> var1);

        public void reportLiveOutput(String var1);
    }
}

