/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.util.HashMap;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractLibrary
extends AbstractClasspathEntry {
    private static final String DEPRECATED_DECLAREDCONFIGNAME_FIELD = "AbstractLibrary.declaredConfigurationName";
    private FileReference sourcePath;
    private FileReference javadocPath;
    private FileReference library;
    private String declaredConfigurationName;
    private ModuleVersionIdentifier moduleVersion;

    public AbstractLibrary(Node node, FileReferenceFactory fileReferenceFactory) {
        super(node);
        String javadocLocation = (String)this.getEntryAttributes().get("javadoc_location");
        this.javadocPath = fileReferenceFactory.fromJarURI(javadocLocation);
    }

    public AbstractLibrary(FileReference library) {
        super(library.getPath());
        this.library = library;
    }

    public FileReference getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(FileReference sourcePath) {
        this.sourcePath = sourcePath;
    }

    public FileReference getJavadocPath() {
        return this.javadocPath;
    }

    public void setJavadocPath(FileReference path) {
        this.javadocPath = path;
        String location = path != null ? path.getJarURL() : null;
        this.getEntryAttributes().put("javadoc_location", location);
    }

    public FileReference getLibrary() {
        return this.library;
    }

    public void setLibrary(FileReference library) {
        this.library = library;
        this.setPath(library.getPath());
    }

    @Deprecated
    public String getDeclaredConfigurationName() {
        DeprecationLogger.nagUserOfDeprecated((String)DEPRECATED_DECLAREDCONFIGNAME_FIELD);
        return this.declaredConfigurationName;
    }

    @Deprecated
    public void setDeclaredConfigurationName(String declaredConfigurationName) {
        DeprecationLogger.nagUserOfDeprecated((String)DEPRECATED_DECLAREDCONFIGNAME_FIELD);
        this.declaredConfigurationName = declaredConfigurationName;
    }

    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(@Nullable ModuleVersionIdentifier moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public void appendNode(Node node) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("sourcepath", this.sourcePath == null ? null : this.sourcePath.getPath());
        this.addClasspathEntry(node, attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractLibrary that = (AbstractLibrary)o;
        return Objects.equal((Object)this.getExported(), (Object)that.getExported()) && Objects.equal(this.getAccessRules(), that.getAccessRules()) && Objects.equal((Object)this.getJavadocPath(), (Object)that.getJavadocPath()) && Objects.equal((Object)this.getNativeLibraryLocation(), (Object)that.getNativeLibraryLocation()) && Objects.equal((Object)this.getPath(), (Object)that.getPath()) && Objects.equal((Object)this.getSourcePath(), (Object)that.getSourcePath());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getNativeLibraryLocation(), this.getExported(), this.getAccessRules(), this.getSourcePath(), this.getJavadocPath()});
    }

    public String toString() {
        return "{path='" + this.getPath() + "', nativeLibraryLocation='" + this.getNativeLibraryLocation() + "', exported=" + this.getExported() + ", accessRules=" + this.getAccessRules() + ", sourcePath='" + this.sourcePath + "', javadocPath='" + this.javadocPath + "', id='" + this.moduleVersion + "'}";
    }
}

