/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Task;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.GraphAggregator;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleProjectTaskReportModel
implements TaskReportModel {
    private final SetMultimap<String, TaskDetails> groups = TreeMultimap.create((Comparator)new Comparator<String>(){

        @Override
        public int compare(String string1, String string2) {
            return string1.compareToIgnoreCase(string2);
        }
    }, (Comparator)new Comparator<TaskDetails>(){

        @Override
        public int compare(TaskDetails task1, TaskDetails task2) {
            return task1.getPath().compareTo(task2.getPath());
        }
    });
    private final TaskDetailsFactory factory;

    public SingleProjectTaskReportModel(TaskDetailsFactory factory) {
        this.factory = factory;
    }

    public void build(final Collection<? extends Task> tasks) {
        LinkedHashSet<Task> topLevelTasks = new LinkedHashSet<Task>();
        for (Task task : tasks) {
            if (!GUtil.isTrue((Object)task.getGroup())) continue;
            topLevelTasks.add(task);
        }
        GraphAggregator aggregator = new GraphAggregator((DirectedGraph)new DirectedGraph<Task, Object>(){

            public void getNodeValues(Task node, Collection<? super Object> values, Collection<? super Task> connectedNodes) {
                for (Task dep : node.getTaskDependencies().getDependencies(node)) {
                    if (!SingleProjectTaskReportModel.this.containsTaskWithPath(tasks, dep.getPath())) continue;
                    connectedNodes.add((Task)dep);
                }
            }
        });
        GraphAggregator.Result result = aggregator.group(topLevelTasks, tasks);
        for (Task task : result.getTopLevelNodes()) {
            TreeSet nodesForThisTask = new TreeSet(result.getNodes((Object)task));
            LinkedHashSet<TaskDetails> children = new LinkedHashSet<TaskDetails>();
            LinkedHashSet<TaskDetails> dependencies = new LinkedHashSet<TaskDetails>();
            for (Task node : nodesForThisTask) {
                if (node != task) {
                    children.add(new TaskDetailsImpl(node, this.factory.create(node), Collections.<TaskDetails>emptySet(), Collections.<TaskDetails>emptySet()));
                }
                for (Task dep : node.getTaskDependencies().getDependencies(node)) {
                    if (!topLevelTasks.contains(dep) && this.containsTaskWithPath(tasks, dep.getPath())) continue;
                    dependencies.add(this.factory.create(dep));
                }
            }
            String group = topLevelTasks.contains(task) ? task.getGroup() : "";
            this.groups.put((Object)group, (Object)new TaskDetailsImpl(task, this.factory.create(task), children, dependencies));
        }
    }

    private boolean containsTaskWithPath(Collection<? extends Task> tasks, String path) {
        for (Task task : tasks) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        if (!this.groups.containsKey((Object)group)) {
            throw new IllegalArgumentException(String.format("Unknown group '%s'", group));
        }
        return this.groups.get((Object)group);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskDetailsImpl
    implements TaskDetails {
        private final Task task;
        private final TaskDetails details;
        private final Set<TaskDetails> children;
        private final Set<TaskDetails> dependencies;

        public TaskDetailsImpl(Task task, TaskDetails details, Set<TaskDetails> children, Set<TaskDetails> dependencies) {
            this.task = task;
            this.details = details;
            this.children = children;
            this.dependencies = dependencies;
        }

        @Override
        public Path getPath() {
            return this.details.getPath();
        }

        @Override
        public String getDescription() {
            return this.details.getDescription();
        }

        public String toString() {
            return this.task.toString();
        }

        public Task getTask() {
            return this.task;
        }

        @Override
        public Set<TaskDetails> getDependencies() {
            return this.dependencies;
        }

        @Override
        public Set<TaskDetails> getChildren() {
            return this.children;
        }
    }
}

