/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestFrameworkDetector<T extends TestClassVisitor>
implements TestFrameworkDetector {
    protected static final String TEST_CASE = "junit/framework/TestCase";
    protected static final String GROOVY_TEST_CASE = "groovy/util/GroovyTestCase";
    private List<File> testClassDirectories;
    private final ClassFileExtractionManager classFileExtractionManager;
    private final Map<File, Boolean> superClasses;
    private TestClassProcessor testClassProcessor;
    private final List<String> knownTestCaseClassNames;
    private File testClassesDirectory;
    private FileCollection testClasspath;

    protected AbstractTestFrameworkDetector(ClassFileExtractionManager classFileExtractionManager) {
        assert (classFileExtractionManager != null);
        this.classFileExtractionManager = classFileExtractionManager;
        this.superClasses = new HashMap<File, Boolean>();
        this.knownTestCaseClassNames = new ArrayList<String>();
        this.addKnownTestCaseClassNames(TEST_CASE, GROOVY_TEST_CASE);
    }

    protected abstract T createClassVisitor();

    protected File getSuperTestClassFile(String superClassName) {
        this.prepareClasspath();
        if (StringUtils.isEmpty((String)superClassName)) {
            throw new IllegalArgumentException("superClassName is empty!");
        }
        Iterator<File> testClassDirectoriesIt = this.testClassDirectories.iterator();
        File superTestClassFile = null;
        while (superTestClassFile == null && testClassDirectoriesIt.hasNext()) {
            File testClassDirectory = testClassDirectoriesIt.next();
            File superTestClassFileCandidate = new File(testClassDirectory, superClassName + ".class");
            if (!superTestClassFileCandidate.exists()) continue;
            superTestClassFile = superTestClassFileCandidate;
        }
        if (superTestClassFile != null) {
            return superTestClassFile;
        }
        return this.classFileExtractionManager.getLibraryClassFile(superClassName);
    }

    private void prepareClasspath() {
        if (this.testClassDirectories != null) {
            return;
        }
        this.testClassDirectories = new ArrayList<File>();
        if (this.testClassesDirectory != null) {
            this.testClassDirectories.add(this.testClassesDirectory);
        }
        if (this.testClasspath != null) {
            for (File file : this.testClasspath) {
                if (file.isDirectory()) {
                    this.testClassDirectories.add(file);
                    continue;
                }
                if (!file.isFile() || !FileUtils.hasExtension((File)file, (String)".jar")) continue;
                this.classFileExtractionManager.addLibraryJar(file);
            }
        }
    }

    @Override
    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    @Override
    public void setTestClasspath(FileCollection testClasspath) {
        this.testClasspath = testClasspath;
    }

    protected TestClassVisitor classVisitor(File testClassFile) {
        T classVisitor = this.createClassVisitor();
        BufferedInputStream classStream = null;
        try {
            classStream = new BufferedInputStream(new FileInputStream(testClassFile));
            ClassReader classReader = new ClassReader((InputStream)classStream);
            classReader.accept(classVisitor, 7);
        }
        catch (Throwable e) {
            try {
                throw new GradleException("failed to read class file " + testClassFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)classStream);
        return classVisitor;
    }

    @Override
    public boolean processTestClass(File testClassFile) {
        return this.processTestClass(testClassFile, false);
    }

    protected abstract boolean processTestClass(File var1, boolean var2);

    protected boolean processSuperClass(File testClassFile) {
        boolean isTest = false;
        Boolean isSuperTest = this.superClasses.get(testClassFile);
        if (isSuperTest == null) {
            isTest = this.processTestClass(testClassFile, true);
            this.superClasses.put(testClassFile, isTest);
        } else {
            isTest = isSuperTest;
        }
        return isTest;
    }

    protected void publishTestClass(boolean isTest, TestClassVisitor classVisitor, boolean superClass) {
        if (isTest && !classVisitor.isAbstract() && !superClass) {
            String className = Type.getObjectType((String)classVisitor.getClassName()).getClassName();
            this.testClassProcessor.processTestClass((TestClassRunInfo)new DefaultTestClassRunInfo(className));
        }
    }

    @Override
    public void startDetection(TestClassProcessor testClassProcessor) {
        this.testClassProcessor = testClassProcessor;
    }

    public void addKnownTestCaseClassNames(String ... knownTestCaseClassNames) {
        if (knownTestCaseClassNames != null && knownTestCaseClassNames.length != 0) {
            for (String knownTestCaseClassName : knownTestCaseClassNames) {
                if (!StringUtils.isNotEmpty((String)knownTestCaseClassName)) continue;
                this.knownTestCaseClassNames.add(knownTestCaseClassName.replaceAll("\\.", "/"));
            }
        }
    }

    protected boolean isKnownTestCaseClassName(String testCaseClassName) {
        boolean isKnownTestCase = false;
        if (StringUtils.isNotEmpty((String)testCaseClassName)) {
            isKnownTestCase = this.knownTestCaseClassNames.contains(testCaseClassName);
        }
        return isKnownTestCase;
    }
}

