/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import com.google.common.base.Joiner;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Incubating;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JacocoTaskExtension
extends GroovyObjectSupport {
    private JacocoAgentJar agent;
    private final JavaForkOptions task;
    private boolean enabled = true;
    private File destinationFile;
    private boolean append = true;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private List<String> excludeClassLoaders = new ArrayList<String>();
    private boolean includeNoLocationClasses;
    private String sessionId;
    private boolean dumpOnExit = true;
    private Output output = Output.FILE;
    private String address;
    private Integer port;
    private File classDumpFile;
    private boolean jmx;

    public JacocoTaskExtension(JacocoAgentJar agent, JavaForkOptions task) {
        this.agent = agent;
        this.task = task;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getExcludeClassLoaders() {
        return this.excludeClassLoaders;
    }

    public void setExcludeClassLoaders(List<String> excludeClassLoaders) {
        this.excludeClassLoaders = excludeClassLoaders;
    }

    public boolean isIncludeNoLocationClasses() {
        return this.includeNoLocationClasses;
    }

    public boolean getIncludeNoLocationClasses() {
        return this.includeNoLocationClasses;
    }

    public void setIncludeNoLocationClasses(boolean includeNoLocationClasses) {
        this.includeNoLocationClasses = includeNoLocationClasses;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isDumpOnExit() {
        return this.dumpOnExit;
    }

    public boolean getDumpOnExit() {
        return this.dumpOnExit;
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.dumpOnExit = dumpOnExit;
    }

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public File getClassDumpFile() {
        return this.classDumpFile;
    }

    public void setClassDumpFile(File classDumpFile) {
        this.classDumpFile = classDumpFile;
    }

    public boolean isJmx() {
        return this.jmx;
    }

    public boolean getJmx() {
        return this.jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }

    @Deprecated
    public JacocoAgentJar getAgent() {
        return this.agent;
    }

    @Deprecated
    public void setAgent(JacocoAgentJar agent) {
        this.agent = agent;
    }

    public String getAsJvmArg() {
        StringBuilder builder = new StringBuilder();
        ArgumentAppender argument = new ArgumentAppender(builder, this.task.getWorkingDir());
        ConventionValueSupplier convention = new ConventionValueSupplier((Object)this);
        builder.append("-javaagent:");
        builder.append(GFileUtils.relativePath((File)this.task.getWorkingDir(), (File)this.agent.getJar()));
        builder.append('=');
        argument.append("destfile", convention.get(this.destinationFile, "destinationFile"));
        argument.append("append", convention.get(this.append, "append"));
        argument.append("includes", convention.get(this.includes, "includes"));
        argument.append("excludes", convention.get(this.excludes, "excludes"));
        argument.append("exclclassloader", convention.get(this.excludeClassLoaders, "excludeClassLoaders"));
        if (this.agent.supportsInclNoLocationClasses()) {
            argument.append("inclnolocationclasses", convention.get(this.includeNoLocationClasses, "includeNoLocationClasses"));
        }
        argument.append("sessionid", convention.get(this.sessionId, "sessionId"));
        argument.append("dumponexit", convention.get(this.dumpOnExit, "dumpOnExit"));
        argument.append("output", convention.get(this.output, "output").getAsArg());
        argument.append("address", convention.get(this.address, "address"));
        argument.append("port", convention.get(this.port, "port"));
        argument.append("classdumpdir", this.classDumpFile);
        if (this.agent.supportsJmx()) {
            argument.append("jmx", convention.get(this.jmx, "jmx"));
        }
        return builder.toString();
    }

    private static class ArgumentAppender {
        private final StringBuilder builder;
        private final File workingDirectory;
        private boolean anyArgs;

        public ArgumentAppender(StringBuilder builder, File workingDirectory) {
            this.builder = builder;
            this.workingDirectory = workingDirectory;
        }

        public void append(String name, Object value) {
            if (!(value == null || value instanceof Collection && ((Collection)value).isEmpty())) {
                if (this.anyArgs) {
                    this.builder.append(',');
                }
                this.builder.append(name).append('=');
                if (value instanceof Collection) {
                    this.builder.append(Joiner.on((char)':').join((Iterable)((Collection)value)));
                } else if (value instanceof File) {
                    this.builder.append(GFileUtils.relativePath((File)this.workingDirectory, (File)((File)value)));
                } else {
                    this.builder.append(value);
                }
                this.anyArgs = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConventionValueSupplier {
        private final ConventionMapping mapping;

        public ConventionValueSupplier(Object delegate) {
            this.mapping = delegate instanceof IConventionAware ? ((IConventionAware)delegate).getConventionMapping() : null;
        }

        public <T> T get(T actualValue, String propertyName) {
            if (this.mapping != null) {
                return (T)this.mapping.getConventionValue(actualValue, propertyName, false);
            }
            return actualValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        FILE,
        TCP_SERVER,
        TCP_CLIENT,
        NONE;


        public String getAsArg() {
            return this.toString().toLowerCase().replaceAll("_", "");
        }
    }
}

