/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.List;
import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.IncomingConnector;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.SocketConnectCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIncomingConnector
implements IncomingConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpIncomingConnector.class);
    private final ExecutorFactory executorFactory;
    private final InetAddressFactory addressFactory;
    private final IdGenerator<UUID> idGenerator;

    public TcpIncomingConnector(ExecutorFactory executorFactory, InetAddressFactory addressFactory, IdGenerator<UUID> idGenerator) {
        this.executorFactory = executorFactory;
        this.addressFactory = addressFactory;
        this.idGenerator = idGenerator;
    }

    @Override
    public ConnectionAcceptor accept(Action<ConnectCompletion> action, boolean allowRemote) {
        int localPort;
        ServerSocketChannel serverSocket;
        try {
            serverSocket = ServerSocketChannel.open();
            serverSocket.socket().bind(new InetSocketAddress(this.addressFactory.findLocalBindingAddress(), 0));
            localPort = serverSocket.socket().getLocalPort();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        UUID id = (UUID)this.idGenerator.generateId();
        List<InetAddress> addresses = allowRemote ? this.addressFactory.findRemoteAddresses() : this.addressFactory.findLocalAddresses();
        final MultiChoiceAddress address = new MultiChoiceAddress(id, localPort, addresses);
        LOGGER.debug("Listening on {}.", (Object)address);
        final StoppableExecutor executor = this.executorFactory.create("Incoming " + (allowRemote ? "remote" : "local") + " TCP Connector on port " + localPort);
        executor.execute((Runnable)new Receiver(serverSocket, action, allowRemote));
        return new ConnectionAcceptor(){

            public Address getAddress() {
                return address;
            }

            public void requestStop() {
                CompositeStoppable.stoppable((Object[])new Object[]{serverSocket}).stop();
            }

            public void stop() {
                this.requestStop();
                executor.stop();
            }
        };
    }

    static /* synthetic */ InetAddressFactory access$000(TcpIncomingConnector x0) {
        return x0.addressFactory;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Receiver
    implements Runnable {
        private final ServerSocketChannel serverSocket;
        private final Action<ConnectCompletion> action;
        private final boolean allowRemote;

        public Receiver(ServerSocketChannel serverSocket, Action<ConnectCompletion> action, boolean allowRemote) {
            this.serverSocket = serverSocket;
            this.action = action;
            this.allowRemote = allowRemote;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block9: {
                try {
                    ** try [egrp 1[TRYBLOCK] [1, 2 : 0->119)] { 
lbl3:
                    // 1 sources

                    break block9;
lbl4:
                    // 1 sources

                    catch (ClosedChannelException e) {
                    }
                }
                catch (Throwable var5_7) {
                    CompositeStoppable.stoppable((Object[])new Object[]{this.serverSocket}).stop();
                    throw var5_7;
                }
            }
            while (true) {
                socket = this.serverSocket.accept();
                remoteSocketAddress = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
                remoteInetAddress = remoteSocketAddress.getAddress();
                if (!this.allowRemote && !TcpIncomingConnector.access$000(TcpIncomingConnector.this).isLocal(remoteInetAddress)) {
                    TcpIncomingConnector.access$100().error("Cannot accept connection from remote address {}.", (Object)remoteInetAddress);
                    socket.close();
                    continue;
                }
                TcpIncomingConnector.access$100().debug("Accepted connection from {} to {}.", (Object)socket.socket().getRemoteSocketAddress(), (Object)socket.socket().getLocalSocketAddress());
                try {
                    this.action.execute((Object)new SocketConnectCompletion(socket));
                }
                catch (Throwable t) {
                    socket.close();
                    throw t;
                }
            }
lbl26:
            // 1 sources

            catch (Throwable e) {
                TcpIncomingConnector.access$100().error("Could not accept remote connection.", e);
            }
            CompositeStoppable.stoppable((Object[])new Object[]{this.serverSocket}).stop();
        }
    }
}

