/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.ProjectIdentifier;

public class DefaultProjectIdentifier
implements ProjectIdentifier,
Serializable {
    private final BuildIdentifier build;
    private final String projectPath;

    public DefaultProjectIdentifier(BuildIdentifier build, String projectPath) {
        this.build = build;
        this.projectPath = projectPath;
    }

    public DefaultProjectIdentifier(File rootDir, String projectPath) {
        this(new DefaultBuildIdentifier(rootDir), projectPath);
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.build;
    }

    public String toString() {
        return String.format("project=%s, %s", this.projectPath, this.build);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectIdentifier that = (DefaultProjectIdentifier)o;
        if (!this.build.equals(that.build)) {
            return false;
        }
        return this.projectPath.equals(that.projectPath);
    }

    public int hashCode() {
        int result = this.build.hashCode();
        result = 31 * result + this.projectPath.hashCode();
        return result;
    }
}

