/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.annotation.Annotation;
import java.util.List;
import org.testng.collections.Lists;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;
import org.testng.xml.dom.TagContent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wrapper {
    private OnElement m_onElement;
    private OnElementList m_onElementList;
    private Tag m_tag;
    private TagContent m_tagContent;
    private Object m_bean;

    public Wrapper(Annotation a, Object bean) {
        this.m_bean = bean;
        if (a instanceof OnElement) {
            this.m_onElement = (OnElement)a;
        } else if (a instanceof OnElementList) {
            this.m_onElementList = (OnElementList)a;
        } else if (a instanceof Tag) {
            this.m_tag = (Tag)a;
        } else if (a instanceof TagContent) {
            this.m_tagContent = (TagContent)a;
        } else {
            throw new RuntimeException("Illegal annotation " + a);
        }
    }

    public String getTagName() {
        if (this.m_onElement != null) {
            return this.m_onElement.tag();
        }
        if (this.m_onElementList != null) {
            return this.m_onElementList.tag();
        }
        return this.m_tag.name();
    }

    public List<Object[]> getParameters(Element element) {
        List<Object[]> allParameters = Lists.newArrayList();
        if (this.m_onElement != null) {
            List result = Lists.newArrayList();
            for (String attributeName : this.m_onElement.attributes()) {
                result.add(element.getAttribute(attributeName));
            }
            allParameters.add(result.toArray());
        } else if (this.m_tag != null) {
            List result = Lists.newArrayList();
            result.add(this.m_bean);
            allParameters.add(result.toArray());
        } else {
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (!childNodes.item(i).hasAttributes()) continue;
                Element item = (Element)childNodes.item(i);
                List result = Lists.newArrayList();
                for (String attributeName : this.m_onElementList.attributes()) {
                    result.add(item.getAttribute(attributeName));
                }
                allParameters.add(result.toArray());
            }
        }
        return allParameters;
    }
}

