/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LazyDataflowVariable<T>
extends DataflowVariable<T> {
    private final Closure<T> initializer;
    private final AtomicBoolean initializationStarted = new AtomicBoolean(false);
    private final PGroup group;

    public LazyDataflowVariable(Closure<T> initializer) {
        this(Dataflow.DATA_FLOW_GROUP, initializer);
    }

    public LazyDataflowVariable(PGroup group, Closure<T> initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException("The LazyDataflowVariable initializer must not be null.");
        }
        if (group == null) {
            throw new IllegalArgumentException("The LazyDataflowVariable initialization group must not be null.");
        }
        this.group = group;
        this.initializer = initializer;
    }

    private void initialize() {
        if (!this.initializationStarted.getAndSet(true)) {
            this.group.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object result = LazyDataflowVariable.this.initializer.call();
                        LazyDataflowVariable.this.leftShift(result);
                    }
                    catch (Throwable e) {
                        LazyDataflowVariable.this.bindError(e);
                    }
                }
            });
        }
    }

    @Override
    public void touch() {
        super.touch();
        this.initialize();
    }

    @Override
    public final boolean isError() {
        this.initialize();
        return super.isError();
    }

    @Override
    public final Throwable getError() {
        this.initialize();
        return super.getError();
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure, Closure<V> errorHandler) {
        this.initialize();
        return super.then(closure, errorHandler);
    }

    @Override
    public final <V> Promise<V> then(Pool pool, Closure<V> closure, Closure<V> errorHandler) {
        this.initialize();
        return super.then(pool, closure, errorHandler);
    }

    @Override
    public final <V> Promise<V> then(PGroup group, Closure<V> closure, Closure<V> errorHandler) {
        this.initialize();
        return super.then(group, closure, errorHandler);
    }

    @Override
    public T getVal() throws InterruptedException {
        this.initialize();
        return super.getVal();
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        this.initialize();
        return super.getVal(timeout, units);
    }

    @Override
    public void getValAsync(MessageStream callback) {
        this.initialize();
        super.getValAsync(callback);
    }

    @Override
    public void getValAsync(Object attachment, MessageStream callback) {
        this.initialize();
        super.getValAsync(attachment, callback);
    }
}

