/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XPathInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("XPath" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/XPathInspection", "getGroupDisplayName"));
        }
        return "XPath";
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        XPathElement e = (XPathElement)PsiTreeUtil.getContextOfType((PsiElement)element, XPathElement.class, (boolean)false);
        SuppressIntentionAction[] suppressIntentionActionArray = ContextProvider.getContextProvider(e != null ? e : element).getQuickFixFactory().getSuppressActions(this);
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/XPathInspection", "getSuppressActions"));
        }
        return suppressIntentionActionArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/validation/inspections/XPathInspection", "isSuppressedFor"));
        }
        return ContextProvider.getContextProvider(element.getContainingFile()).getQuickFixFactory().isSuppressedFor(element, this);
    }

    protected abstract Visitor createVisitor(InspectionManager var1, boolean var2);

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/validation/inspections/XPathInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/intellij/lang/xpath/validation/inspections/XPathInspection", "checkFile"));
        }
        Language language = file.getLanguage();
        if (!this.acceptsLanguage(language)) {
            return null;
        }
        Visitor visitor = this.createVisitor(manager, isOnTheFly);
        file.accept((PsiElementVisitor)visitor);
        return visitor.getProblems();
    }

    protected abstract boolean acceptsLanguage(Language var1);

    static abstract class Visitor
    extends PsiRecursiveElementVisitor {
        protected final InspectionManager myManager;
        protected boolean myOnTheFly;
        private SmartList<ProblemDescriptor> myProblems;

        Visitor(InspectionManager manager, boolean isOnTheFly) {
            this.myManager = manager;
            this.myOnTheFly = isOnTheFly;
        }

        public void visitElement(PsiElement psiElement) {
            super.visitElement(psiElement);
            if (this.myProblems != null) {
                TextRange textRange = psiElement.getTextRange();
                for (ProblemDescriptor problem : this.myProblems) {
                    if (!textRange.contains(problem.getPsiElement().getTextRange())) continue;
                    return;
                }
            }
            if (psiElement instanceof XPathExpression) {
                this.checkExpression((XPathExpression)psiElement);
            } else if (psiElement instanceof XPathNodeTest) {
                this.checkNodeTest((XPathNodeTest)psiElement);
            } else if (psiElement instanceof XPathPredicate) {
                this.checkPredicate((XPathPredicate)psiElement);
            }
        }

        protected void checkExpression(XPathExpression expression) {
        }

        protected void checkPredicate(XPathPredicate predicate) {
        }

        protected void checkNodeTest(XPathNodeTest nodeTest) {
        }

        @Nullable
        private ProblemDescriptor[] getProblems() {
            return this.myProblems == null ? null : (ProblemDescriptor[])this.myProblems.toArray((Object[])new ProblemDescriptor[this.myProblems.size()]);
        }

        void addProblem(ProblemDescriptor problem) {
            if (this.myProblems == null) {
                this.myProblems = new SmartList();
            }
            this.myProblems.add((Object)problem);
        }
    }
}

