/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class ConvertToEntityFix
extends AbstractFix {
    private final XPathToken myToken;
    private final String myValue;

    public ConvertToEntityFix(XPathToken token) {
        this.myToken = token;
        this.myValue = this.myToken.getText().replaceAll("<", "&lt;");
    }

    @NotNull
    public String getText() {
        String string = "Convert '" + this.myToken.getText() + "' to '" + this.myValue + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix", "isAvailableImpl"));
        }
        if (!this.myToken.isValid()) {
            return false;
        }
        PsiFile psiFile = this.myToken.getContainingFile();
        assert (psiFile != null);
        PsiElement context = psiFile.getContext();
        return context != null && context.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix", "invoke"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myToken.getContainingFile(), XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myToken.getLanguage());
        assert (parserDefinition != null);
        XPathFile f = XPathChangeUtil.createXPathFile(this.myToken, "1 " + this.myValue + " 2");
        PsiElement firstChild = f.getFirstChild();
        assert (firstChild != null);
        XPathToken child = (XPathToken)PsiTreeUtil.getChildOfType((PsiElement)firstChild, XPathToken.class);
        assert (child != null);
        this.myToken.replace(child);
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }
}

