/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.context.XsltContextProviderBase;
import org.intellij.lang.xpath.xslt.quickfix.ConvertToEntityFix;
import org.intellij.lang.xpath.xslt.quickfix.FlipOperandsFix;
import org.intellij.lang.xpath.xslt.validation.XsltPatternValidator;
import org.jetbrains.annotations.NotNull;

public class XsltAnnotator
extends XPath2ElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/lang/xpath/xslt/validation/XsltAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/xpath/xslt/validation/XsltAnnotator", "annotate"));
        }
        boolean isXslt = ContextProvider.getContextProvider(psiElement) instanceof XsltContextProviderBase;
        if (isXslt) {
            try {
                this.myHolder = holder;
                psiElement.accept((PsiElementVisitor)this);
            }
            finally {
                this.myHolder = null;
            }
        }
    }

    @Override
    public void visitXPathFile(XPathFile file) {
        XmlAttribute context = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)file, XmlAttribute.class, (boolean)true);
        if (context != null) {
            FileASTNode node;
            if (XsltSupport.isPatternAttribute(context)) {
                XsltPatternValidator.validate(this.myHolder, (PsiFile)file);
            } else if (file.getText().trim().length() == 0 && file.getExpression() == null) {
                this.myHolder.createErrorAnnotation((PsiElement)file, "Empty XPath expression");
            }
            if (XsltSupport.isXsltAttribute(context) && !XsltSupport.mayBeAVT(context) && (node = file.getNode()) != null && node.findChildByType(XPathTokenTypes.LBRACE) != null) {
                this.myHolder.createErrorAnnotation((PsiElement)file, "Attribute Value Template is not allowed here");
            }
        }
    }

    @Override
    public void visitXPathToken(XPathToken token) {
        if (XPathTokenTypes.REL_OPS.contains(token.getTokenType()) && token.textContains('<')) {
            Annotation ann = this.myHolder.createErrorAnnotation((PsiElement)token, "'<' must be escaped as '&lt;' in XSLT documents");
            ann.registerFix((IntentionAction)new ConvertToEntityFix(token));
            ann.registerFix((IntentionAction)new FlipOperandsFix(token));
        }
    }
}

