/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntFilesProvider;
import com.intellij.lang.ant.dom.AntDomFilesProviderImpl;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomPattern;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.SubTagList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntDomFileList
extends AntDomFilesProviderImpl {
    @Attribute(value="dir")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getDir();

    @Attribute(value="files")
    public abstract GenericAttributeValue<String> getFilesString();

    @SubTagList(value="file")
    public abstract List<AntDomNamedElement> getFiles();

    @Override
    @Nullable
    protected AntDomPattern getAntPattern() {
        return null;
    }

    @Override
    @NotNull
    protected List<File> getFiles(@Nullable AntDomPattern pattern, Set<AntFilesProvider> processed) {
        File root = this.getCanonicalFile(this.getDir().getStringValue());
        if (root == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileList", "getFiles"));
            }
            return list;
        }
        ArrayList<File> files = new ArrayList<File>();
        String filenames = this.getFilesString().getStringValue();
        if (filenames != null) {
            StringTokenizer tokenizer = new StringTokenizer(filenames, ", \t\n\r\f", false);
            while (tokenizer.hasMoreTokens()) {
                files.add(new File(root, tokenizer.nextToken()));
            }
        }
        for (AntDomNamedElement child : this.getFiles()) {
            String fileName = child.getName().getStringValue();
            if (fileName == null) continue;
            files.add(new File(root, fileName));
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileList", "getFiles"));
        }
        return arrayList;
    }
}

