/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomFileReferenceSet;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.PathTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntMultiPathStringConverter
extends Converter<List<File>>
implements CustomReferenceConverter<List<File>> {
    public List<File> fromString(@Nullable @NonNls String s, ConvertContext context) {
        final GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        String path = attribValue.getStringValue();
        if (path == null) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        Computable<String> basedirComputable = null;
        PathTokenizer pathTokenizer = new PathTokenizer(path);
        while (pathTokenizer.hasMoreTokens()) {
            File file = new File(pathTokenizer.nextToken());
            if (!file.isAbsolute()) {
                String baseDir;
                if (basedirComputable == null) {
                    basedirComputable = new Computable<String>(){
                        final String myBaseDir;
                        {
                            AntDomProject antProject = AntMultiPathStringConverter.getEffectiveAntProject(attribValue);
                            this.myBaseDir = antProject != null ? antProject.getProjectBasedirPath() : null;
                        }

                        public String compute() {
                            return this.myBaseDir;
                        }
                    };
                }
                if ((baseDir = (String)basedirComputable.compute()) == null) continue;
                file = new File(baseDir, path);
            }
            result.add(file);
        }
        return result;
    }

    private static AntDomProject getEffectiveAntProject(GenericAttributeValue attribValue) {
        AntDomProject project = (AntDomProject)attribValue.getParentOfType(AntDomProject.class, false);
        if (project != null) {
            project = project.getContextAntProject();
        }
        return project;
    }

    public String toString(@Nullable List<File> files, ConvertContext context) {
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        return attribValue.getRawText();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<List<File>> genericDomValue, PsiElement element, ConvertContext context) {
        GenericAttributeValue attributeValue = (GenericAttributeValue)genericDomValue;
        String cpString = genericDomValue.getRawText();
        if (cpString == null || cpString.length() == 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntMultiPathStringConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        PathTokenizer pathTokenizer = new PathTokenizer(cpString);
        int searchFromIndex = 0;
        while (pathTokenizer.hasMoreTokens()) {
            String path = pathTokenizer.nextToken();
            if (path.length() <= 0) continue;
            int pathBeginIndex = cpString.indexOf(path, searchFromIndex);
            AntDomFileReferenceSet refSet = new AntDomFileReferenceSet(attributeValue, path, pathBeginIndex, false);
            ContainerUtil.addAll(result, (Object[])refSet.getAllReferences());
            searchFromIndex = pathBeginIndex;
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntMultiPathStringConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

