/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<T, V> {
    private static final Unsafe unsafe = ReflectionUtil.getStaticFieldValue(Unsafe.class, Unsafe.class, "theUnsafe");
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        Unsafe unsafe = AtomicFieldUpdater.unsafe;
        if (unsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AtomicFieldUpdater", "getUnsafe"));
        }
        return unsafe;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/util/concurrency/AtomicFieldUpdater", "forFieldOfType"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "com/intellij/util/concurrency/AtomicFieldUpdater", "forFieldOfType"));
        }
        AtomicFieldUpdater<T, V> atomicFieldUpdater = new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
        if (atomicFieldUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AtomicFieldUpdater", "forFieldOfType"));
        }
        return atomicFieldUpdater;
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/util/concurrency/AtomicFieldUpdater", "forLongFieldIn"));
        }
        AtomicFieldUpdater<T, Long> atomicFieldUpdater = new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
        if (atomicFieldUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AtomicFieldUpdater", "forLongFieldIn"));
        }
        return atomicFieldUpdater;
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Integer> forIntFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/util/concurrency/AtomicFieldUpdater", "forIntFieldIn"));
        }
        AtomicFieldUpdater<T, Integer> atomicFieldUpdater = new AtomicFieldUpdater<T, Integer>(ownerClass, Integer.TYPE);
        if (atomicFieldUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AtomicFieldUpdater", "forIntFieldIn"));
        }
        return atomicFieldUpdater;
    }

    private AtomicFieldUpdater(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/util/concurrency/AtomicFieldUpdater", "<init>"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "com/intellij/util/concurrency/AtomicFieldUpdater", "<init>"));
        }
        Field found = AtomicFieldUpdater.getTheOnlyVolatileFieldOfClass(ownerClass, fieldType);
        this.offset = unsafe.objectFieldOffset(found);
    }

    @NotNull
    private static <T, V> Field getTheOnlyVolatileFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/util/concurrency/AtomicFieldUpdater", "getTheOnlyVolatileFieldOfClass"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "com/intellij/util/concurrency/AtomicFieldUpdater", "getTheOnlyVolatileFieldOfClass"));
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x18) != 0 || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        if ((found.getModifiers() & 0x40) == 0) {
            throw new IllegalArgumentException("Field " + found + " in the " + ownerClass + " must be volatile");
        }
        Field field = found;
        if (field == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AtomicFieldUpdater", "getTheOnlyVolatileFieldOfClass"));
        }
        return field;
    }

    public boolean compareAndSet(@NotNull T owner, V expected, V newValue) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/concurrency/AtomicFieldUpdater", "compareAndSet"));
        }
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull T owner, long expected, long l) {
        void newValue;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/concurrency/AtomicFieldUpdater", "compareAndSetLong"));
        }
        return unsafe.compareAndSwapLong(owner, this.offset, expected, (long)newValue);
    }

    public boolean compareAndSetInt(@NotNull T owner, int expected, int newValue) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/concurrency/AtomicFieldUpdater", "compareAndSetInt"));
        }
        return unsafe.compareAndSwapInt(owner, this.offset, expected, newValue);
    }

    public void set(@NotNull T owner, V newValue) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/concurrency/AtomicFieldUpdater", "set"));
        }
        unsafe.putObjectVolatile(owner, this.offset, newValue);
    }

    public V get(@NotNull T owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/concurrency/AtomicFieldUpdater", "get"));
        }
        return (V)unsafe.getObjectVolatile(owner, this.offset);
    }

    static {
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
    }
}

