/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.StripedLockHolder;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class LockPoolSynchronizedMap<K, V>
extends THashMap<K, V>
implements ConcurrentMap<K, V> {
    private final Lock r;
    private final Lock w;
    private static final StripedLockHolder<ReentrantReadWriteLock> LOCKS = new StripedLockHolder<ReentrantReadWriteLock>(ReentrantReadWriteLock.class){

        @Override
        @NotNull
        protected ReentrantReadWriteLock create() {
            ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
            if (reentrantReadWriteLock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockPoolSynchronizedMap$1", "create"));
            }
            return reentrantReadWriteLock;
        }
    };

    public LockPoolSynchronizedMap() {
        ReentrantReadWriteLock mutex = LOCKS.allocateLock();
        this.r = mutex.readLock();
        this.w = mutex.writeLock();
    }

    public LockPoolSynchronizedMap(int initialCapacity) {
        super(initialCapacity);
        ReentrantReadWriteLock mutex = LOCKS.allocateLock();
        this.r = mutex.readLock();
        this.w = mutex.writeLock();
    }

    public LockPoolSynchronizedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        ReentrantReadWriteLock mutex = LOCKS.allocateLock();
        this.r = mutex.readLock();
        this.w = mutex.writeLock();
    }

    @Override
    public int size() {
        this.r.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.r.lock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.r.lock();
        try {
            boolean bl = super.containsValue(value);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.r.lock();
        try {
            Object object = super.get(key);
            return (V)object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.w.lock();
        try {
            Object object = super.put(key, value);
            return (V)object;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.w.lock();
        try {
            Object object = super.remove(key);
            return (V)object;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/LockPoolSynchronizedMap", "putAll"));
        }
        this.w.lock();
        try {
            super.putAll(map);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void clear() {
        this.w.lock();
        try {
            super.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    public LockPoolSynchronizedMap<K, V> clone() {
        this.r.lock();
        try {
            LockPoolSynchronizedMap lockPoolSynchronizedMap = (LockPoolSynchronizedMap)super.clone();
            return lockPoolSynchronizedMap;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        this.r.lock();
        Set set = super.keySet();
        Set set2 = set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockPoolSynchronizedMap", "keySet"));
        }
        return set2;
        finally {
            this.r.unlock();
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        this.r.lock();
        Set set = super.entrySet();
        Set set2 = set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockPoolSynchronizedMap", "entrySet"));
        }
        return set2;
        finally {
            this.r.unlock();
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        this.r.lock();
        Collection collection = super.values();
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockPoolSynchronizedMap", "values"));
        }
        return collection2;
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/LockPoolSynchronizedMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/LockPoolSynchronizedMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/LockPoolSynchronizedMap", "replace"));
        }
        this.w.lock();
        try {
            V prev = this.get(key);
            if (!Comparing.equal(oldValue, prev)) {
                boolean bl = false;
                return bl;
            }
            this.put(key, newValue);
            boolean bl = true;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(@NotNull K key, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/LockPoolSynchronizedMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/LockPoolSynchronizedMap", "replace"));
        }
        this.w.lock();
        try {
            V prev = this.get(key);
            this.put(key, newValue);
            V v = prev;
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/LockPoolSynchronizedMap", "putIfAbsent"));
        }
        this.w.lock();
        try {
            V prev = this.get(key);
            if (prev == null) {
                this.put(key, value);
                V v = value;
                return v;
            }
            V v = prev;
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Object key, Object oldValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/LockPoolSynchronizedMap", "remove"));
        }
        this.w.lock();
        try {
            V currentValue = this.get(key);
            boolean bl = Comparing.equal(oldValue, currentValue) && super.remove(key) != null;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }
}

