/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public final class WeakValueHashMap<K, V>
extends RefValueHashMap<K, V> {
    public WeakValueHashMap() {
    }

    public WeakValueHashMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/WeakValueHashMap", "<init>"));
        }
        super(strategy);
    }

    @Override
    protected RefValueHashMap.MyReference<K, V> createReference(@NotNull K key, V value, @NotNull ReferenceQueue<V> queue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/WeakValueHashMap", "createReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/WeakValueHashMap", "createReference"));
        }
        return new MyWeakReference(key, value, queue);
    }

    private static class MyWeakReference<K, T>
    extends WeakReference<T>
    implements RefValueHashMap.MyReference<K, T> {
        private final K key;

        private MyWeakReference(K key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }
}

