/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataReader {
    private static final Logger LOG = Logger.getInstance(BaseDataReader.class);
    protected final SleepingPolicy mySleepingPolicy;
    protected volatile boolean isStopped;
    private Future<?> myFinishedFuture;

    public BaseDataReader(SleepingPolicy sleepingPolicy) {
        this.mySleepingPolicy = sleepingPolicy != null ? sleepingPolicy : SleepingPolicy.SIMPLE;
    }

    @Deprecated
    protected void start() {
        this.start("");
    }

    protected void start(final @NotNull String presentableName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/util/io/BaseDataReader", "start"));
        }
        if (StringUtil.isEmptyOrSpaces(presentableName)) {
            LOG.warn(new Throwable("Must provide not-empty presentable name"));
        }
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    String oldThreadName = Thread.currentThread().getName();
                    if (!StringUtil.isEmptyOrSpaces(presentableName)) {
                        Thread.currentThread().setName(StringUtil.first("BaseDataReader: " + presentableName, 120, true));
                    }
                    try {
                        BaseDataReader.this.doRun();
                    }
                    finally {
                        Thread.currentThread().setName(oldThreadName);
                    }
                }
            });
        }
    }

    @NotNull
    protected abstract Future<?> executeOnPooledThread(@NotNull Runnable var1);

    protected void doRun() {
        try {
            boolean stopSignalled = false;
            while (true) {
                boolean read = this.readAvailable();
                if (stopSignalled) break;
                if (this.mySleepingPolicy == SleepingPolicy.BLOCKING) {
                    break;
                }
                stopSignalled = this.isStopped;
                if (stopSignalled) continue;
                TimeoutUtil.sleep(this.mySleepingPolicy.getTimeToSleep(read));
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Can't close stream", e);
            }
        }
    }

    protected abstract boolean readAvailable() throws IOException;

    protected abstract void close() throws IOException;

    public void stop() {
        this.isStopped = true;
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myFinishedFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public static class AdaptiveSleepingPolicy
    implements SleepingPolicy {
        private static final int maxSleepTimeWhenIdle = 200;
        private static final int maxIterationsWithCurrentSleepTime = 50;
        private volatile int myIterationsWithCurrentTime;
        private volatile int myCurrentSleepTime = 5;

        @Override
        public int getTimeToSleep(boolean wasActive) {
            int iterationsWithCurrentTime;
            int currentSleepTime = this.myCurrentSleepTime;
            if (wasActive) {
                currentSleepTime = 1;
            } else if (currentSleepTime == 1) {
                currentSleepTime = 5;
                this.myIterationsWithCurrentTime = 0;
            } else if ((iterationsWithCurrentTime = ++this.myIterationsWithCurrentTime) >= 50) {
                this.myIterationsWithCurrentTime = 0;
                currentSleepTime = Math.min(2 * currentSleepTime, 200);
            }
            this.myCurrentSleepTime = currentSleepTime;
            return currentSleepTime;
        }
    }

    public static interface SleepingPolicy {
        public static final int sleepTimeWhenWasActive = 1;
        public static final int sleepTimeWhenIdle = 5;
        public static final SleepingPolicy SIMPLE = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return wasActive ? 1 : 5;
            }
        };
        public static final SleepingPolicy BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return 50;
            }
        };

        public int getTimeToSleep(boolean var1);
    }
}

