/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EdtInvocationManager {
    @NotNull
    private static volatile EdtInvocationManager ourInstance = new SwingEdtInvocationManager();

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager edtInvocationManager = ourInstance;
        if (edtInvocationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/EdtInvocationManager", "getInstance"));
        }
        return edtInvocationManager;
    }

    public static void setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        if (edtInvocationManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtInvocationManager", "com/intellij/util/ui/EdtInvocationManager", "setEdtInvocationManager"));
        }
        ourInstance = edtInvocationManager;
    }

    private static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        private SwingEdtInvocationManager() {
        }

        @Override
        public boolean isEventDispatchThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager", "invokeLater"));
            }
            SwingUtilities.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager", "invokeAndWait"));
            }
            SwingUtilities.invokeAndWait(task);
        }
    }
}

