/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageEnabledConfiguration
extends CoverageEnabledConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration");
    private ClassFilter[] myCoveragePatterns;
    private boolean myIsMergeWithPreviousResults = false;
    private String mySuiteToMergeWith;
    @NonNls
    private static final String COVERAGE_PATTERN_ELEMENT_NAME = "pattern";
    @NonNls
    private static final String COVERAGE_MERGE_ATTRIBUTE_NAME = "merge";
    @NonNls
    private static final String COVERAGE_MERGE_SUITE_ATT_NAME = "merge_suite";
    private JavaCoverageEngine myCoverageProvider;

    public JavaCoverageEnabledConfiguration(RunConfigurationBase configuration, JavaCoverageEngine coverageProvider) {
        super(configuration);
        this.myCoverageProvider = coverageProvider;
        this.setCoverageRunner(CoverageRunner.getInstance(IDEACoverageRunner.class));
    }

    @Nullable
    public static JavaCoverageEnabledConfiguration getFrom(RunConfigurationBase configuration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getOrCreate(configuration);
        if (coverageEnabledConfiguration instanceof JavaCoverageEnabledConfiguration) {
            return (JavaCoverageEnabledConfiguration)coverageEnabledConfiguration;
        }
        return null;
    }

    public void appendCoverageArgument(RunConfigurationBase configuration, SimpleJavaParameters javaParameters) {
        CoverageRunner runner = this.getCoverageRunner();
        try {
            if (runner != null && runner instanceof JavaCoverageRunner) {
                String path = this.getCoverageFilePath();
                assert (path != null);
                String sourceMapPath = null;
                if (this.myCoverageProvider.isSourceMapNeeded(configuration)) {
                    sourceMapPath = JavaCoverageEnabledConfiguration.getSourceMapPath(path);
                }
                ((JavaCoverageRunner)runner).appendCoverageArgument(new File(path).getCanonicalPath(), this.getPatterns(), javaParameters, this.isTrackPerTestCoverage() && !this.isSampling(), this.isSampling(), sourceMapPath);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static String getSourceMapPath(String coverageDataFilePath) {
        return coverageDataFilePath + ".sourceMap";
    }

    @NotNull
    public JavaCoverageEngine getCoverageProvider() {
        JavaCoverageEngine javaCoverageEngine = this.myCoverageProvider;
        if (javaCoverageEngine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/coverage/JavaCoverageEnabledConfiguration", "getCoverageProvider"));
        }
        return javaCoverageEngine;
    }

    public ClassFilter[] getCoveragePatterns() {
        return this.myCoveragePatterns;
    }

    @Nullable
    public String[] getPatterns() {
        if (this.myCoveragePatterns != null) {
            ArrayList<String> patterns = new ArrayList<String>();
            for (ClassFilter coveragePattern : this.myCoveragePatterns) {
                if (!coveragePattern.isEnabled()) continue;
                patterns.add(coveragePattern.getPattern());
            }
            return ArrayUtil.toStringArray(patterns);
        }
        return null;
    }

    public void setCoveragePatterns(ClassFilter[] coveragePatterns) {
        this.myCoveragePatterns = coveragePatterns;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String mergeAttribute = element.getAttributeValue(COVERAGE_MERGE_ATTRIBUTE_NAME);
        this.myIsMergeWithPreviousResults = mergeAttribute != null && Boolean.valueOf(mergeAttribute) != false;
        this.mySuiteToMergeWith = element.getAttributeValue(COVERAGE_MERGE_SUITE_ATT_NAME);
        List children = element.getChildren(COVERAGE_PATTERN_ELEMENT_NAME);
        if (children.size() > 0) {
            this.myCoveragePatterns = new ClassFilter[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element e = (Element)children.get(i);
                this.myCoveragePatterns[i] = JavaCoverageEnabledConfiguration.createClassFilter(e);
                String val = e.getAttributeValue("value");
                if (val == null) continue;
                this.myCoveragePatterns[i].setPattern(val);
            }
        }
    }

    public static ClassFilter createClassFilter(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        boolean trackTestFolders;
        boolean sampling;
        boolean trackPerTestCoverage;
        element.setAttribute("enabled", String.valueOf(this.isCoverageEnabled()));
        element.setAttribute(COVERAGE_MERGE_ATTRIBUTE_NAME, String.valueOf(this.myIsMergeWithPreviousResults));
        if (this.myIsMergeWithPreviousResults && this.mySuiteToMergeWith != null) {
            element.setAttribute(COVERAGE_MERGE_SUITE_ATT_NAME, this.mySuiteToMergeWith);
        }
        if (!(trackPerTestCoverage = this.isTrackPerTestCoverage())) {
            element.setAttribute("per_test_coverage_enabled", String.valueOf(trackPerTestCoverage));
        }
        if (sampling = this.isSampling()) {
            element.setAttribute("sample_coverage", String.valueOf(sampling));
        }
        if (trackTestFolders = this.isTrackTestFolders()) {
            element.setAttribute("track_test_folders", String.valueOf(trackTestFolders));
        }
        CoverageRunner coverageRunner = this.getCoverageRunner();
        String runnerId = this.getRunnerId();
        if (coverageRunner != null) {
            element.setAttribute("runner", coverageRunner.getId());
        } else if (runnerId != null) {
            element.setAttribute("runner", runnerId);
        }
        if (this.myCoveragePatterns != null) {
            for (ClassFilter pattern : this.myCoveragePatterns) {
                Element patternElement = new Element(COVERAGE_PATTERN_ELEMENT_NAME);
                DefaultJDOMExternalizer.writeExternal((Object)pattern, (Element)patternElement);
                element.addContent(patternElement);
            }
        }
    }

    @Override
    @Nullable
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath != null) {
            return this.myCoverageFilePath;
        }
        this.myCoverageFilePath = this.createCoverageFile();
        return this.myCoverageFilePath;
    }

    public void setUpCoverageFilters(@Nullable String className, @Nullable String packageName) {
        if (this.getCoveragePatterns() == null) {
            String pattern = null;
            if (!StringUtil.isEmpty((String)className)) {
                int index = className.lastIndexOf(46);
                if (index >= 0) {
                    pattern = className.substring(0, index);
                }
            } else if (packageName != null) {
                pattern = packageName;
            }
            if (!StringUtil.isEmpty((String)pattern)) {
                this.setCoveragePatterns(new ClassFilter[]{new ClassFilter(pattern + ".*")});
            }
        }
    }
}

