/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicMethodDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class DynamicMethodFix
implements IntentionAction,
LowPriorityAction {
    private final GrReferenceExpression myReferenceExpression;
    private final String mySignature;

    public DynamicMethodFix(GrReferenceExpression referenceExpression, PsiType[] argumentTypes) {
        this.myReferenceExpression = referenceExpression;
        this.mySignature = this.calcSignature(argumentTypes);
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.method", new Object[0]) + this.mySignature;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix", "getText"));
        }
        return string;
    }

    private String calcSignature(PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder(" '").append(this.myReferenceExpression.getReferenceName());
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType type = argTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(type.getPresentableText());
        }
        builder.append(")");
        builder.append("' ");
        return builder.toString();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix", "isAvailable"));
        }
        return this.myReferenceExpression.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix", "invoke"));
        }
        DynamicMethodDialog dialog = new DynamicMethodDialog(this.myReferenceExpression);
        dialog.show();
    }

    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = QuickfixUtil.createSettings(this.myReferenceExpression);
        DynamicManager.getInstance(project).addMethod(settings);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }
}

