/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class BaseInspectionVisitor
extends GroovyRecursiveElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.problemsHolder = problemsHolder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerStatementError(GrStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError(statementToken, args);
    }

    protected void registerClassError(GrTypeDefinition aClass, Object ... args) {
        PsiElement statementToken = aClass.getNameIdentifierGroovy();
        this.registerError(statementToken, args);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(location));
        this.registerError(location, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodError(GrMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(method.getNameIdentifierGroovy(), description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerVariableError(GrVariable variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(variable);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(variable.getNameIdentifierGroovy(), description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodCallError(GrMethodCall method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        GrExpression invoked = method.getInvokedExpression();
        PsiElement nameElement = ((GrReferenceExpression)invoked).getReferenceNameElement();
        assert (nameElement != null);
        this.registerError(nameElement, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerError(@NotNull PsiElement location, @NotNull String description, @Nullable LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor", "registerError"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor", "registerError"));
        }
        this.problemsHolder.registerProblem(location, description, highlightType, fixes);
    }

    protected void registerError(@NotNull PsiElement location, Object ... args) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor", "registerError"));
        }
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, args);
    }

    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor", "registerError"));
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(location, description, fix, highlightType);
    }

    @Nullable
    private LocalQuickFix[] createFixes(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor", "createFixes"));
        }
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(location);
        if (fixes != null) {
            return fixes;
        }
        GroovyFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new GroovyFix[]{fix};
    }

    public int getErrorCount() {
        return this.problemsHolder.getResultCount();
    }
}

