/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrInspectionUtil {
    public static boolean isNull(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isNull"));
        }
        return "null".equals(expression.getText());
    }

    public static boolean isEquality(@NotNull GrBinaryExpression binaryCondition) {
        if (binaryCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryCondition", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isEquality"));
        }
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mEQUAL == tokenType;
    }

    public static boolean isInequality(@NotNull GrBinaryExpression binaryCondition) {
        if (binaryCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryCondition", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isInequality"));
        }
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mNOT_EQUAL == tokenType;
    }

    public static HighlightInfo createAnnotationForRef(@NotNull GrReferenceElement ref, @NotNull HighlightDisplayLevel displayLevel, @NotNull String message) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "createAnnotationForRef"));
        }
        if (displayLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayLevel", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "createAnnotationForRef"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "createAnnotationForRef"));
        }
        PsiElement refNameElement = ref.getReferenceNameElement();
        assert (refNameElement != null);
        if (displayLevel == HighlightDisplayLevel.ERROR) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refNameElement).descriptionAndTooltip(message).create();
        }
        if (displayLevel == HighlightDisplayLevel.WEAK_WARNING) {
            boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
            HighlightInfoType infotype = isTestMode ? HighlightInfoType.WARNING : HighlightInfoType.INFORMATION;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infotype).range(refNameElement);
            builder.descriptionAndTooltip(message);
            return builder.needsUpdateOnTyping(false).textAttributes(GroovySyntaxHighlighter.UNRESOLVED_ACCESS).create();
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)displayLevel.getSeverity());
        return HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(refNameElement).descriptionAndTooltip(message).create();
    }
}

