/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;

public class GrModifierFix
extends GroovyFix {
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST = new Function<ProblemDescriptor, PsiModifierList>(){

        public PsiModifierList fun(ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            assert (element instanceof PsiModifierList) : element;
            return (PsiModifierList)element;
        }
    };
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST_OWNER = new Function<ProblemDescriptor, PsiModifierList>(){

        public PsiModifierList fun(ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            assert (element instanceof PsiModifierListOwner) : element;
            return ((PsiModifierListOwner)element).getModifierList();
        }
    };
    private final String myModifier;
    private final String myText;
    private final boolean myDoSet;
    private final Function<ProblemDescriptor, PsiModifierList> myModifierListProvider;

    public GrModifierFix(@NotNull PsiVariable member, @GrModifier.GrModifierConstant String modifier, boolean doSet, @NotNull Function<ProblemDescriptor, PsiModifierList> modifierListProvider) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "<init>"));
        }
        if (modifierListProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListProvider", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "<init>"));
        }
        this.myModifier = modifier;
        this.myDoSet = doSet;
        this.myModifierListProvider = modifierListProvider;
        this.myText = GrModifierFix.initText(doSet, member.getName(), modifier);
    }

    public GrModifierFix(@NotNull PsiMember member, @GrModifier.GrModifierConstant String modifier, boolean showContainingClass, boolean doSet, @NotNull Function<ProblemDescriptor, PsiModifierList> modifierListProvider) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "<init>"));
        }
        if (modifierListProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListProvider", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "<init>"));
        }
        this.myModifier = modifier;
        this.myDoSet = doSet;
        this.myModifierListProvider = modifierListProvider;
        this.myText = GrModifierFix.initText(doSet, GrModifierFix.getMemberName(member, showContainingClass), modifier);
    }

    public static String initText(boolean doSet, @NotNull String name, @NotNull String modifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "initText"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "initText"));
        }
        return GroovyBundle.message(doSet ? "change.modifier" : "change.modifier.not", name, GrModifierFix.toPresentableText(modifier));
    }

    private static String getMemberName(PsiMember member, boolean showContainingClass) {
        if (showContainingClass) {
            PsiClass containingClass = member.getContainingClass();
            String containingClassName = containingClass != null ? containingClass.getName() + "." : "";
            return containingClassName + member.getName();
        }
        return member.getName();
    }

    public static String toPresentableText(String modifier) {
        return GroovyBundle.message(modifier + ".visibility.presentation", new Object[0]);
    }

    @NotNull
    public String getName() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("change.modifier.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiModifierList modifierList = this.getModifierList(descriptor);
        modifierList.setModifierProperty(this.myModifier, this.myDoSet);
    }

    private PsiModifierList getModifierList(ProblemDescriptor descriptor) {
        return (PsiModifierList)this.myModifierListProvider.fun((Object)descriptor);
    }
}

