/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.JavaStylePropertiesUtil;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class JavaStylePropertiesInvocationFixer
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = GroovyIntentionsBundle.message("java.style.properties.invocation.intention.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationFixer", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("java.style.properties.invocation.intention.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationFixer", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationFixer", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationFixer", "applyFix"));
        }
        PsiElement pparent = descriptor.getPsiElement().getParent().getParent();
        if (pparent instanceof GrMethodCall) {
            JavaStylePropertiesUtil.fixJavaStyleProperty((GrMethodCall)pparent);
        }
    }
}

