/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public class GroovyConsoleUtil {
    public static final Condition<Module> APPLICABLE_MODULE = new Condition<Module>(){

        public boolean value(Module module) {
            return GroovyFacetUtil.isSuitableModule(module);
        }
    };
    private static final Function<Module, String> MODULE_VERSION = new Function<Module, String>(){

        public String fun(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleUtil$2", "fun"));
            }
            String moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module);
            boolean bundled = moduleGroovyHomePath == null || !GroovyConsoleUtil.hasGroovyAll(module);
            String homePathToUse = bundled ? GroovyFacetUtil.getBundledGroovyJar().getParentFile().getParent() : moduleGroovyHomePath;
            String version = GroovyConfigUtils.getInstance().getSDKVersion(homePathToUse);
            return version == "undefined" ? "" : (bundled ? "Bundled " : "") + "Groovy " + version;
        }
    };

    static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, ModuleChooserUtil.filterGroovyCompatibleModules(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()), APPLICABLE_MODULE), MODULE_VERSION, consumer);
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer, DataContext context) {
        ModuleChooserUtil.selectModule(project, ModuleChooserUtil.filterGroovyCompatibleModules(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()), APPLICABLE_MODULE), MODULE_VERSION, consumer, context);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String getTitle(@Nullable Module module) {
        return module == null ? null : String.format("%s (%s)", module.getName(), MODULE_VERSION.fun((Object)module));
    }
}

