/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyEditorTextProvider
implements EditorTextProvider {
    public TextWithImports getEditorText(PsiElement elementAtCaret) {
        String result = "";
        PsiElement element = GroovyEditorTextProvider.findExpressionInner(elementAtCaret, true);
        if (element != null) {
            PsiEnumConstant enumConstant;
            PsiClass enumClass;
            PsiElement resolved;
            GrReferenceExpression reference;
            if (element instanceof GrReferenceExpression && (reference = (GrReferenceExpression)element).getQualifier() == null && (resolved = reference.resolve()) instanceof PsiEnumConstant && (enumClass = (enumConstant = (PsiEnumConstant)resolved).getContainingClass()) != null) {
                result = enumClass.getName() + "." + enumConstant.getName();
            }
            if (result.isEmpty()) {
                result = element.getText();
            }
        }
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, result);
    }

    @Nullable
    private static PsiElement findExpressionInner(PsiElement element, boolean allowMethodCalls) {
        PsiElement parent = element.getParent();
        if (parent instanceof GrVariable && element == ((GrVariable)parent).getNameIdentifierGroovy()) {
            return element;
        }
        if (parent instanceof GrReferenceExpression) {
            PsiElement pparent = parent.getParent();
            if (pparent instanceof GrCall) {
                parent = pparent;
            }
            if (allowMethodCalls || !GroovyRefactoringUtil.hasSideEffect((GroovyPsiElement)parent)) {
                return parent;
            }
        }
        return null;
    }

    public Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        PsiElement expression = GroovyEditorTextProvider.findExpressionInner(element, allowMethodCalls);
        if (expression == null) {
            return null;
        }
        return Pair.create((Object)expression, (Object)expression.getTextRange());
    }
}

