/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class CompositeContextFilter
implements ContextFilter {
    private final List<ContextFilter> myFilters;
    private final boolean myAnd;

    private CompositeContextFilter(List<ContextFilter> filters, boolean and) {
        this.myFilters = filters;
        this.myAnd = and;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        for (ContextFilter filter : this.myFilters) {
            if (this.myAnd == filter.isApplicable(descriptor, ctx)) continue;
            return !this.myAnd;
        }
        return this.myAnd;
    }

    @NotNull
    public static ContextFilter compose(@NotNull List<ContextFilter> filters, boolean and) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "org/jetbrains/plugins/groovy/dsl/toplevel/CompositeContextFilter", "compose"));
        }
        if (filters.size() == 1) {
            ContextFilter contextFilter = filters.get(0);
            if (contextFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/CompositeContextFilter", "compose"));
            }
            return contextFilter;
        }
        CompositeContextFilter compositeContextFilter = new CompositeContextFilter(filters, and);
        if (compositeContextFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/CompositeContextFilter", "compose"));
        }
        return compositeContextFilter;
    }
}

