/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GrJoinControlStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(Document document, PsiFile file, int start, int end) {
        if (!(file instanceof GroovyFileBase)) {
            return -1;
        }
        PsiElement startElement = file.findElementAt(start);
        if (startElement == null || !startElement.getNode().getElementType().equals(GroovyTokenTypes.mRPAREN)) {
            return -1;
        }
        PsiElement parent = startElement.getParent();
        if (!(parent instanceof GrIfStatement || parent instanceof GrWhileStatement || parent instanceof GrForStatement)) {
            return -1;
        }
        GrStatement inner = parent instanceof GrIfStatement ? ((GrIfStatement)parent).getThenBranch() : (parent instanceof GrWhileStatement ? ((GrWhileStatement)parent).getBody() : ((GrForStatement)parent).getBody());
        if (inner instanceof GrBlockStatement) {
            return -1;
        }
        document.replaceString(start + 1, end, (CharSequence)" ");
        return start + 2;
    }
}

