/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GppTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return true;
    }

    @Override
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (context instanceof GrListOrMap && context.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)context.getReference()).getConstructedClassType() != null) {
            return null;
        }
        if (rType instanceof GrTupleType) {
            PsiType tupleComponent;
            PsiType[] parameters;
            GrTupleType tupleType = (GrTupleType)rType;
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
            if (expectedComponent != null && GppTypeConverter.isMethodCallConversion(context) && (parameters = tupleType.getParameters()).length == 1 && (tupleComponent = parameters[0]) != null && TypesUtil.isAssignable(expectedComponent, tupleComponent, context) && GppTypeConverter.hasDefaultConstructor(lType)) {
                return true;
            }
        }
        return null;
    }

    public static boolean isClosureOverride(PsiType[] methodParameters, GrClosureType closureType, GroovyPsiElement context) {
        GrSignature signature = closureType.getSignature();
        return methodParameters != null && GrClosureSignatureUtil.isSignatureApplicable(signature, methodParameters, context);
    }

    public static boolean hasDefaultConstructor(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        return psiClass != null && PsiUtil.hasDefaultConstructor((PsiClass)psiClass, (boolean)true, (boolean)false);
    }
}

