/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ExpandBooleanPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ExpandBooleanIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanIntention", "getElementPredicate"));
        }
        return expandBooleanPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanIntention", "processIntention"));
        }
        GrStatement containingStatement = (GrStatement)element;
        if (ExpandBooleanPredicate.isBooleanAssignment(containingStatement)) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)containingStatement;
            GrExpression rhs = assignmentExpression.getRValue();
            assert (rhs != null);
            String rhsText = rhs.getText();
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            String statement = "if(" + rhsText + "){\n" + lhsText + " = true\n}else{\n" + lhsText + " = false\n}";
            PsiImplUtil.replaceStatement(statement, containingStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(containingStatement)) {
            GrReturnStatement returnStatement = (GrReturnStatement)containingStatement;
            GrExpression returnValue = returnStatement.getReturnValue();
            String valueText = returnValue.getText();
            String statement = "if(" + valueText + "){\nreturn true\n}else{\nreturn false\n}";
            PsiImplUtil.replaceStatement(statement, containingStatement);
        }
    }
}

