/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ivy;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.ivy.AbstractAttachSourceProvider");

    @Nullable
    protected static VirtualFile getJarByPsiFile(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(psiFile.getVirtualFile());
        if (jar == null || !jar.getName().endsWith(".jar")) {
            return null;
        }
        return jar;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(List<LibraryOrderEntry> orderEntries) {
        if (orderEntries.isEmpty()) {
            return null;
        }
        Library library = orderEntries.get(0).getLibrary();
        if (library == null) {
            return null;
        }
        for (int i = 1; i < orderEntries.size(); ++i) {
            if (library.equals(orderEntries.get(i).getLibrary())) continue;
            return null;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile jarRoot, @NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/groovy/ivy/AbstractAttachSourceProvider", "addSourceFile"));
        }
        if (jarRoot != null && !Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(jarRoot)) {
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(jarRoot, OrderRootType.SOURCES);
            model.commit();
        }
    }

    protected abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;

        public DownloadSourcesAction(Project project, String messageGroupId, String url) {
            this.myProject = project;
            this.myUrl = url;
            this.myMessageGroupId = messageGroupId;
        }

        public String getName() {
            return "Download Sources";
        }

        public String getBusyText() {
            return "Downloading Sources...";
        }

        protected abstract void storeFile(byte[] var1);

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            final ActionCallback callback = new ActionCallback();
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Downloading Sources", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    byte[] bytes;
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/ivy/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                    }
                    try {
                        LOG.info("Downloading sources JAR: " + DownloadSourcesAction.this.myUrl);
                        indicator.checkCanceled();
                        bytes = HttpRequests.request((String)DownloadSourcesAction.this.myUrl).readBytes(indicator);
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new Notification(DownloadSourcesAction.this.myMessageGroupId, "Downloading failed", "Failed to download sources: " + DownloadSourcesAction.this.myUrl, NotificationType.ERROR).notify(this.getProject());
                                callback.setDone();
                            }
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AccessToken accessToken = WriteAction.start();
                            try {
                                DownloadSourcesAction.this.storeFile(bytes);
                            }
                            finally {
                                accessToken.finish();
                                callback.setDone();
                            }
                        }
                    });
                }

                public void onCancel() {
                    callback.setRejected();
                }
            };
            task.queue();
            return callback;
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final String myName;
        private final VirtualFile mySrcFile;
        private final Library myLibrary;

        public AttachExistingSourceAction(VirtualFile srcFile, Library library, String actionName) {
            this.mySrcFile = srcFile;
            this.myLibrary = library;
            this.myName = actionName;
        }

        public String getName() {
            return this.myName;
        }

        public String getBusyText() {
            return this.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ActionCallback callback = new ActionCallback();
            callback.setDone();
            if (!this.mySrcFile.isValid()) {
                return callback;
            }
            if (this.myLibrary != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntriesContainingFile)) {
                return callback;
            }
            AccessToken accessToken = WriteAction.start();
            try {
                AbstractAttachSourceProvider.this.addSourceFile(this.mySrcFile, this.myLibrary);
            }
            finally {
                accessToken.finish();
            }
            return callback;
        }
    }
}

