/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GrDummyIdentifierProvider {
    public static final String DUMMY_IDENTIFIER_DECAPITALIZED = StringUtil.decapitalize((String)"IntellijIdeaRulezzz ");
    private final CompletionInitializationContext myContext;

    public GrDummyIdentifierProvider(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider", "<init>"));
        }
        this.myContext = context;
    }

    @Nullable
    public String getIdentifier() {
        if (this.myContext.getCompletionType() == CompletionType.BASIC && this.myContext.getFile() instanceof GroovyFile) {
            PsiElement position = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
            if (position != null && position.getParent() instanceof GrVariable && position == ((GrVariable)position.getParent()).getNameIdentifierGroovy() || position != null && position.getParent() instanceof GrAnnotationNameValuePair && position == ((GrAnnotationNameValuePair)position.getParent()).getNameIdentifierGroovy()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            if (this.isIdentifierBeforeLParenth()) {
                return this.setCorrectCase() + ";";
            }
            if (GroovyCompletionUtil.isInPossibleClosureParameter(position)) {
                return this.setCorrectCase() + "->";
            }
            if (this.isBeforeAssign()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            return this.setCorrectCase();
        }
        return null;
    }

    private boolean isBeforeAssign() {
        HighlighterIterator iterator = ((EditorEx)this.myContext.getEditor()).getHighlighter().createIterator(this.myContext.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mASSIGN;
    }

    @NotNull
    private String setCorrectCase() {
        PsiElement element = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
        if (element == null) {
            String string = DUMMY_IDENTIFIER_DECAPITALIZED;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider", "setCorrectCase"));
            }
            return string;
        }
        String text = element.getText();
        if (text.isEmpty()) {
            String string = DUMMY_IDENTIFIER_DECAPITALIZED;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider", "setCorrectCase"));
            }
            return string;
        }
        String string = Character.isUpperCase(text.charAt(0)) ? "IntellijIdeaRulezzz " : DUMMY_IDENTIFIER_DECAPITALIZED;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider", "setCorrectCase"));
        }
        return string;
    }

    private boolean isIdentifierBeforeLParenth() {
        HighlighterIterator iterator = ((EditorEx)this.myContext.getEditor()).getHighlighter().createIterator(this.myContext.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mLPAREN;
    }
}

