/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.types;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeSpec {
    public static ReferenceElement.ReferenceElementResult parse(PsiBuilder builder) {
        return TypeSpec.parse(builder, false, true);
    }

    public static ReferenceElement.ReferenceElementResult parse(PsiBuilder builder, boolean isUpper, boolean expressionPossible) {
        if (TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType())) {
            return TypeSpec.parseBuiltInType(builder);
        }
        if (builder.getTokenType() == GroovyTokenTypes.mIDENT) {
            return TypeSpec.parseClassType(builder, isUpper, expressionPossible);
        }
        return ReferenceElement.ReferenceElementResult.FAIL;
    }

    public static ReferenceElement.ReferenceElementResult parseBuiltInType(PsiBuilder builder) {
        PsiBuilder.Marker arrMarker = builder.mark();
        ParserUtils.eatElement(builder, GroovyElementTypes.BUILT_IN_TYPE);
        if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType())) {
            TypeSpec.declarationBracketsParse(builder, arrMarker);
        } else {
            arrMarker.drop();
        }
        return ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS;
    }

    private static void declarationBracketsParse(PsiBuilder builder, PsiBuilder.Marker marker) {
        ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)GroovyElementTypes.ARRAY_TYPE);
        if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType())) {
            TypeSpec.declarationBracketsParse(builder, newMarker);
        } else {
            newMarker.drop();
        }
    }

    private static ReferenceElement.ReferenceElementResult parseClassType(PsiBuilder builder, boolean isUpper, boolean expressionPossible) {
        PsiBuilder.Marker arrMarker = builder.mark();
        PsiBuilder.Marker typeElementMarker = builder.mark();
        ReferenceElement.ReferenceElementResult result = ReferenceElement.parseReferenceElement(builder, isUpper, expressionPossible);
        if (result == ReferenceElement.ReferenceElementResult.FAIL) {
            typeElementMarker.drop();
            arrMarker.rollbackTo();
            return ReferenceElement.ReferenceElementResult.FAIL;
        }
        typeElementMarker.done((IElementType)GroovyElementTypes.CLASS_TYPE_ELEMENT);
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mRBRACK)) {
            TypeSpec.declarationBracketsParse(builder, arrMarker);
            return ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS;
        }
        arrMarker.drop();
        return result;
    }

    public static ReferenceElement.ReferenceElementResult parseStrict(PsiBuilder builder, boolean expressionPossible) {
        if (TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType())) {
            return TypeSpec.parseBuiltInTypeStrict(builder);
        }
        if (builder.getTokenType() == GroovyTokenTypes.mIDENT) {
            return TypeSpec.parseClassOrInterfaceTypeStrict(builder, expressionPossible);
        }
        return ReferenceElement.ReferenceElementResult.FAIL;
    }

    private static ReferenceElement.ReferenceElementResult parseBuiltInTypeStrict(PsiBuilder builder) {
        PsiBuilder.Marker arrMarker = builder.mark();
        ParserUtils.eatElement(builder, GroovyElementTypes.BUILT_IN_TYPE);
        if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, arrMarker) ? ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS : ReferenceElement.ReferenceElementResult.FAIL;
        }
        arrMarker.drop();
        return ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS;
    }

    private static boolean declarationBracketsParseStrict(PsiBuilder builder, PsiBuilder.Marker marker) {
        ParserUtils.getToken(builder, GroovyTokenTypes.mLBRACK);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]))) {
            marker.rollbackTo();
            return false;
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)GroovyElementTypes.ARRAY_TYPE);
        if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, newMarker);
        }
        newMarker.drop();
        return true;
    }

    private static ReferenceElement.ReferenceElementResult parseClassOrInterfaceTypeStrict(PsiBuilder builder, boolean expressionPossible) {
        PsiBuilder.Marker arrMarker = builder.mark();
        PsiBuilder.Marker typeElementMarker = builder.mark();
        ReferenceElement.ReferenceElementResult result = ReferenceElement.parseReferenceElement(builder, false, expressionPossible);
        if (result == ReferenceElement.ReferenceElementResult.FAIL) {
            typeElementMarker.drop();
            arrMarker.rollbackTo();
            return result;
        }
        typeElementMarker.done((IElementType)GroovyElementTypes.CLASS_TYPE_ELEMENT);
        if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, arrMarker) ? ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS : ReferenceElement.ReferenceElementResult.FAIL;
        }
        arrMarker.drop();
        return result;
    }
}

