/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapImpl
extends GrExpressionImpl
implements GrListOrMap {
    private static final TokenSet MAP_LITERAL_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.NAMED_ARGUMENT, GroovyTokenTypes.mCOLON});
    private static final Function<GrListOrMapImpl, PsiType> TYPES_CALCULATOR = new MyTypesCalculator();
    private final PsiReference myLiteralReference;
    private volatile GrExpression[] myInitializers;
    private volatile GrNamedArgument[] myNamedArguments;

    public GrListOrMapImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl", "<init>"));
        }
        super(node);
        this.myLiteralReference = new LiteralConstructorReference(this);
        this.myInitializers = null;
        this.myNamedArguments = null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitListOrMap(this);
    }

    public String toString() {
        return "Generalized list";
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (this.getInitializers().length == 0) {
            return super.addInternal(first, last, this.getNode().getFirstChildNode(), Boolean.valueOf(false));
        }
        ASTNode lastChild = this.getNode().getLastChildNode();
        this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", lastChild);
        return super.addInternal(first, last, lastChild.getTreePrev(), Boolean.valueOf(false));
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl", "deleteChildInternal"));
        }
        PsiElement psi = child.getPsi();
        if (psi instanceof GrExpression || psi instanceof GrNamedArgument) {
            PsiElement prev = PsiUtil.getPrevNonSpace(psi);
            PsiElement next = PsiUtil.getNextNonSpace(psi);
            if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(prev.getNode());
            } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(next.getNode());
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    public boolean isMap() {
        return this.findChildByType(MAP_LITERAL_TOKEN_SET) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.getInitializers().length == 0 && this.getNamedArguments().length == 0;
    }

    @Override
    public PsiElement getLBrack() {
        return this.findChildByType(GroovyTokenTypes.mLBRACK);
    }

    @Override
    public PsiElement getRBrack() {
        return this.findChildByType(GroovyTokenTypes.mRBRACK);
    }

    @Override
    @NotNull
    public GrExpression[] getInitializers() {
        GrExpression[] initializers = this.myInitializers;
        if (initializers == null) {
            initializers = (GrExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrExpression.class);
            initializers = initializers == null ? GrExpression.EMPTY_ARRAY : initializers;
            this.myInitializers = initializers;
        }
        if (initializers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl", "getInitializers"));
        }
        return initializers;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] namedArguments = this.myNamedArguments;
        if (namedArguments == null) {
            namedArguments = (GrNamedArgument[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrNamedArgument.class);
            namedArguments = namedArguments == null ? GrNamedArgument.EMPTY_ARRAY : namedArguments;
            this.myNamedArguments = namedArguments;
        }
        if (namedArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl", "getNamedArguments"));
        }
        return namedArguments;
    }

    @Override
    public GrNamedArgument findNamedArgument(@NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl", "findNamedArgument"));
        }
        return PsiImplUtil.findNamedArgument(this, label);
    }

    public PsiReference getReference() {
        return this.myLiteralReference;
    }

    public void subtreeChanged() {
        this.myInitializers = null;
        this.myNamedArguments = null;
    }

    private static class MyTypesCalculator
    implements Function<GrListOrMapImpl, PsiType> {
        private MyTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrListOrMapImpl listOrMap) {
            PsiType declaredType;
            GrTypeElement typeElement;
            if (listOrMap.isMap()) {
                return MyTypesCalculator.inferMapInitializerType(listOrMap);
            }
            PsiElement parent = listOrMap.getParent();
            if (parent.getParent() instanceof GrVariableDeclaration && (typeElement = ((GrVariableDeclaration)parent.getParent()).getTypeElementGroovy()) != null && (declaredType = typeElement.getType()) instanceof PsiArrayType) {
                return declaredType;
            }
            return MyTypesCalculator.getTupleType(listOrMap.getInitializers(), listOrMap);
        }

        @Nullable
        private static PsiClassType inferMapInitializerType(GrListOrMapImpl listOrMap) {
            PsiType lType;
            GrNamedArgument[] namedArgs = listOrMap.getNamedArguments();
            if (namedArgs.length == 0 && (lType = PsiImplUtil.inferExpectedTypeForDiamond(listOrMap)) instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Map")) {
                GlobalSearchScope scope = listOrMap.getResolveScope();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)listOrMap.getProject());
                PsiClass hashMap = facade.findClass("java.util.LinkedHashMap", scope);
                if (hashMap != null) {
                    PsiSubstitutor mapSubstitutor = PsiSubstitutor.EMPTY.put(hashMap.getTypeParameters()[0], com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)0, (boolean)false)).put(hashMap.getTypeParameters()[1], com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)1, (boolean)false));
                    return facade.getElementFactory().createType(hashMap, mapSubstitutor);
                }
            }
            return GrMapType.createFromNamedArgs(listOrMap, namedArgs);
        }

        private static PsiClassType getTupleType(final GrExpression[] initializers, GrListOrMap listOrMap) {
            PsiType lType;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)listOrMap.getProject());
            GlobalSearchScope scope = listOrMap.getResolveScope();
            if (initializers.length == 0 && (lType = PsiImplUtil.inferExpectedTypeForDiamond(listOrMap)) instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.List")) {
                PsiClass arrayList = facade.findClass("java.util.ArrayList", scope);
                if (arrayList == null) {
                    arrayList = facade.findClass("java.util.List", scope);
                }
                if (arrayList != null) {
                    PsiSubstitutor arrayListSubstitutor = PsiSubstitutor.EMPTY.put(arrayList.getTypeParameters()[0], com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.List", (int)0, (boolean)false));
                    return facade.getElementFactory().createType(arrayList, arrayListSubstitutor);
                }
            }
            return new GrTupleType(scope, facade){

                @Override
                @NotNull
                protected PsiType[] inferComponents() {
                    PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map((Object[])initializers, (Function)new Function<GrExpression, PsiType>(){

                        public PsiType fun(final GrExpression expression) {
                            return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, (Computable)new Computable<PsiType>(){

                                public PsiType compute() {
                                    return TypesUtil.boxPrimitiveType(expression.getType(), expression.getManager(), myScope);
                                }
                            });
                        }
                    }, (Object[])new PsiType[initializers.length]);
                    if (psiTypeArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl$MyTypesCalculator$1", "inferComponents"));
                    }
                    return psiTypeArray;
                }

                public boolean isValid() {
                    for (GrExpression initializer : initializers) {
                        if (initializer.isValid()) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
    }
}

