/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.profiling.ResolveProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrSuperReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrThisReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorBuilder;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private static final ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl> POLY_RESOLVER = new ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrReferenceExpressionImpl refExpr, boolean incompleteCode) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1", "resolve"));
            }
            GroovyResolveResult[] groovyResolveResultArray = refExpr.doPolyResolve(incompleteCode);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1", "resolve"));
            }
            return groovyResolveResultArray;
        }
    };
    private static final OurTypesCalculator TYPES_CALCULATOR = new OurTypesCalculator();

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    private static List<GroovyResolveResult> filterMembersFromSuperClasses(GroovyResolveResult[] results) {
        ArrayList<GroovyResolveResult> filtered = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult result : results) {
            String name;
            PsiClass containingClass;
            PsiElement element = result.getElement();
            if (element instanceof PsiMember && (((PsiMember)element).hasModifierProperty("private") || (containingClass = ((PsiMember)element).getContainingClass()) != null && (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Map") || (name = containingClass.getQualifiedName()) != null && name.startsWith("java.") || containingClass.getLanguage() != GroovyLanguage.INSTANCE && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"groovy.lang.GroovyObject")))) continue;
            filtered.add(result);
        }
        ArrayList<GroovyResolveResult> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "filterMembersFromSuperClasses"));
        }
        return arrayList;
    }

    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GroovyResolveResult[] groovyResolveResultArray = this._resolve(false, true, upToArgument);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getCallVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode lastChild = this.getNode().getLastChildNode();
        if (lastChild == null) {
            return null;
        }
        if (TokenSets.REFERENCE_NAMES.contains(lastChild.getElementType())) {
            return lastChild.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        GrReferenceExpressionImpl grReferenceExpressionImpl = this;
        if (grReferenceExpressionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getReference"));
        }
        return grReferenceExpressionImpl;
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    @Nullable
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name;
        GroovyResolveResult result = this.advancedResolve();
        if (result.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        return this.handleElementRenameSimple(newElementName);
    }

    protected GrReferenceExpression bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindWithQualifiedRef"));
        }
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public boolean isFullyQualified() {
        if (!ResolveUtil.canResolveToMethod(this) && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    @Override
    public PsiElement handleElementRenameSimple(String newElementName) throws IncorrectOperationException {
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        return super.handleElementRenameSimple(newElementName);
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public final PsiElement resolve() {
        return this.advancedResolve().getElement();
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        PsiType type;
        GroovyResolveResult resolveResult = this.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        IElementType dotType = this.getDotTokenType();
        if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
            return GrClosureType.create(this.multiResolve(false), this);
        }
        if (ResolveUtil.isDefinitelyKeyOfMap(this) && (type = GrReferenceExpressionImpl.getTypeFromMapAccess(this)) != null) {
            return type;
        }
        PsiType result = this.getNominalTypeInner(resolved);
        if (result == null) {
            return null;
        }
        result = TypesUtil.substituteAndNormalizeType(result, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), this);
        return result;
    }

    @Nullable
    private PsiType getNominalTypeInner(@Nullable PsiElement resolved) {
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                }
                return factory.createType((PsiClass)resolved);
            }
            if (this.getParent() instanceof GrReferenceExpression) {
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this.getProject(), this.getResolveScope());
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName())) {
                return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(this), this.getProject(), this.getResolveScope());
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef = GrReferenceExpressionImpl.getTypeFromClassRef(this);
            if (fromClassRef != null) {
                return fromClassRef;
            }
            PsiType fromMapAccess = GrReferenceExpressionImpl.getTypeFromMapAccess(this);
            if (fromMapAccess != null) {
                return fromMapAccess;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromMapAccess(@NotNull GrReferenceExpressionImpl ref) {
        PsiType substituted;
        PsiSubstitutor substitutor;
        PsiClass mapClass;
        PsiClassType.ClassResolveResult qResult;
        PsiClass clazz;
        PsiType qType;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromMapAccess"));
        }
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return null;
        }
        if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.Map", ref.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null && (substituted = substitutor.substitute(mapClass.getTypeParameters()[1])) != null) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(substituted, ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromSpreadOperator"));
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromClassRef(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromClassRef"));
        }
        if ("class".equals(ref.getReferenceName())) {
            return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(ref), ref.getProject(), ref.getResolveScope());
        }
        return null;
    }

    @Nullable
    private static PsiType getInferredTypes(@NotNull GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getInferredTypes"));
        }
        GrExpression qualifier = refExpr.getQualifier();
        if (!(resolved instanceof PsiClass) && !(resolved instanceof PsiPackage)) {
            PsiType mapValueType;
            if (qualifier == null) {
                return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
            }
            PsiType qType = qualifier.getType();
            if (qType instanceof PsiClassType && !(qType instanceof GrMapType) && (mapValueType = GrReferenceExpressionImpl.getTypeFromMapAccess(refExpr)) != null) {
                return mapValueType;
            }
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "replaceWithExpression"));
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GroovyResolveResult[] doPolyResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray;
        block26: {
            GroovyResolveResult[] results;
            GroovyResolveResult[] results2;
            PsiElement nameElement = this.getReferenceNameElement();
            String name = this.getReferenceName();
            if (name == null || nameElement == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            ResolveProfiler.start();
            boolean canBeMethod = ResolveUtil.canResolveToMethod(this);
            if (!canBeMethod) {
                if (ResolveUtil.isDefinitelyKeyOfMap(this)) {
                    GroovyResolveResult[] groovyResolveResultArray2 = GroovyResolveResult.EMPTY_ARRAY;
                    if (groovyResolveResultArray2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return groovyResolveResultArray2;
                }
                IElementType nameType = nameElement.getNode().getElementType();
                if (nameType == GroovyTokenTypes.kTHIS) {
                    results2 = GrThisReferenceResolver.resolveThisExpression(this);
                    if (results2 != null) {
                        GroovyResolveResult[] groovyResolveResultArray3 = results2;
                        if (groovyResolveResultArray3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                        }
                        return groovyResolveResultArray3;
                    }
                } else if (nameType == GroovyTokenTypes.kSUPER && (results2 = GrSuperReferenceResolver.resolveSuperExpression(this)) != null) {
                    GroovyResolveResult[] groovyResolveResultArray4 = results2;
                    if (groovyResolveResultArray4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return groovyResolveResultArray4;
                }
            }
            if ((results = this._resolve(incompleteCode, false, null)).length == 0) {
                results2 = GroovyResolveResult.EMPTY_ARRAY;
                if (results2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                }
                return results2;
            }
            if (!canBeMethod) {
                if (!ResolveUtil.mayBeKeyOfMap(this)) {
                    results2 = results;
                    if (results2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return results2;
                }
                List<GroovyResolveResult> filtered = GrReferenceExpressionImpl.filterMembersFromSuperClasses(results);
                GroovyResolveResult[] time = (GroovyResolveResult[])ContainerUtil.toArray(filtered, (Object[])new GroovyResolveResult[filtered.size()]);
                if (time == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                }
                return time;
            }
            groovyResolveResultArray = results;
            if (groovyResolveResultArray != null) break block26;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
        }
        return groovyResolveResultArray;
        finally {
            long time = ResolveProfiler.finish();
            ResolveProfiler.write((String)"ref", (PsiElement)this, (long)time);
        }
    }

    @NotNull
    private GroovyResolveResult[] _resolve(boolean incomplete, boolean allVariants, @Nullable GrExpression upToArgument) {
        GroovyResolverProcessor processor = GroovyResolverProcessorBuilder.builder().setIncomplete(incomplete).setAllVariants(allVariants).setUpToArgument(upToArgument).build(this);
        new GrReferenceResolveRunner(this, processor).resolveImpl();
        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidatesArray();
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "_resolve"));
        }
        return groovyResolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean hasAt() {
        return this.findChildByType(GroovyTokenTypes.mAT) != null;
    }

    @Override
    public boolean hasMemberPointer() {
        return this.findChildByType(GroovyTokenTypes.mMEMBER_POINTER) != null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiMethod[] superMethods;
        PsiElement baseTarget = this.resolve();
        if (this.getManager().areElementsEquivalent(element, baseTarget)) {
            return true;
        }
        PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
        if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
            return true;
        }
        return element instanceof PsiMethod && target instanceof PsiMethod && Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(TokenSets.DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, POLY_RESOLVER);
        return results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incomplete) {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, incomplete, POLY_RESOLVER);
        GroovyResolveResult[] groovyResolveResultArray = results.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : results;
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getSameNameVariants() {
        GroovyResolveResult[] groovyResolveResultArray = this.doPolyResolve(true);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getSameNameVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindToElementViaStaticImport"));
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    private static final class OurTypesCalculator
    implements Function<GrReferenceExpressionImpl, PsiType> {
        private OurTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrReferenceExpressionImpl refExpr) {
            GroovyResolveResult resolveResult;
            PsiElement resolvedF;
            Object type;
            PsiElement resolved = refExpr.resolve();
            for (GrExpressionTypeCalculator calculator : (GrExpressionTypeCalculator[])GrExpressionTypeCalculator.EP_NAME.getExtensions()) {
                PsiType type2 = calculator.calculateType(refExpr, resolved);
                if (type2 == null) continue;
                return type2;
            }
            if (ResolveUtil.isClassReference(refExpr)) {
                GrExpression qualifier = refExpr.getQualifier();
                LOG.assertTrue(qualifier != null);
                return TypesUtil.createJavaLangClassType(qualifier.getType(), refExpr.getProject(), refExpr.getResolveScope());
            }
            if (PsiUtil.isCompileStatic(refExpr) && (type = (resolvedF = (resolveResult = refExpr.advancedResolve()).getElement()) instanceof GrField ? ((GrField)resolvedF).getType() : (resolvedF instanceof GrAccessorMethod ? ((GrAccessorMethod)resolvedF).getProperty().getType() : null)) != null) {
                return resolveResult.getSubstitutor().substitute(type);
            }
            PsiType nominal = refExpr.getNominalType();
            Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
            if (reassigned != null && reassigned.booleanValue()) {
                return GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
            }
            PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
            if (inferred == null) {
                if (nominal == null && resolved instanceof GrVariable) {
                    LOG.assertTrue(resolved.isValid());
                    return ((GrVariable)resolved).getTypeGroovy();
                }
                return nominal;
            }
            if (nominal == null) {
                return inferred;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && resolved instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
                return nominal;
            }
            return inferred;
        }
    }
}

