/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;

public class GrTypeParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrTypeParameterList,
StubBasedPsiElement<EmptyStub> {
    private static final ArrayFactory<GrTypeParameter> ARRAY_FACTORY = new ArrayFactory<GrTypeParameter>(){

        @NotNull
        public GrTypeParameter[] create(int count) {
            GrTypeParameter[] grTypeParameterArray = new GrTypeParameter[count];
            if (grTypeParameterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl$1", "create"));
            }
            return grTypeParameterArray;
        }
    };

    public GrTypeParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    public String toString() {
        return "Type parameter list";
    }

    @Override
    public GrTypeParameter[] getTypeParameters() {
        return (GrTypeParameter[])this.getStubOrPsiChildren(GroovyElementTypes.TYPE_PARAMETER, ARRAY_FACTORY);
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        GrTypeParameter[] typeParameters = this.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameters[i].equals(typeParameter)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTypeParameterList(this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        this.appendParenthesesIfNeeded();
        if (first == last && first.getPsi() instanceof GrTypeParameter) {
            boolean hasParams;
            boolean bl = hasParams = this.getTypeParameters().length > 0;
            ASTNode _anchor = anchor == null ? (before.booleanValue() ? this.getLastChild().getNode() : this.getFirstChild().getNode()) : anchor;
            ASTNode node = super.addInternal(first, last, _anchor, before);
            if (hasParams) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor != null ? anchor : node);
            }
            return node;
        }
        return super.addInternal(first, last, anchor, before);
    }

    private void appendParenthesesIfNeeded() {
        GrModifierList list;
        PsiElement[] modifiers;
        PsiElement parent;
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first == null) {
            this.getNode().addLeaf(GroovyTokenTypes.mLT, (CharSequence)"<", null);
        }
        if ((last = this.getLastChild()).getNode().getElementType() != GroovyTokenTypes.mGT) {
            this.getNode().addLeaf(GroovyTokenTypes.mGT, (CharSequence)">", null);
        }
        if ((parent = this.getParent()) instanceof GrMethod && (modifiers = (list = ((GrMethod)parent).getModifierList()).getModifiers()).length == 0) {
            list.setModifierProperty("def", true);
        }
    }
}

