/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyShortenFQNamesProcessor
implements TemplateOptionalProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.template.GroovyShortenFQNamesProcessor");

    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.isToShortenLongNames()) {
            return;
        }
        try {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (file instanceof GroovyFile) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, templateRange.getStartOffset(), templateRange.getEndOffset());
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return template.isToShortenLongNames();
    }

    public void setEnabled(Template template, boolean value) {
    }

    public boolean isVisible(Template template) {
        return false;
    }
}

