/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private JPanel myPanel;
    private final DeviceContext myDeviceContext;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, String> myPreferredClients;
    public boolean myIgnoreActionEvents;
    @NotNull
    private JComboBox myDeviceCombo;
    @NotNull
    private JComboBox myClientCombo;
    @Nullable
    private String myCandidateClientName;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/DevicePanel", "<init>"));
        }
        this.myProject = project;
        this.myDeviceContext = context;
        this.$$$setupUI$$$();
        this.myPreferredClients = Maps.newHashMap();
        this.myCandidateClientName = this.getApplicationName();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.initializeDeviceCombo();
        this.initializeClientCombo();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    private void initializeDeviceCombo() {
        this.myDeviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicePanel.this.myIgnoreActionEvents) {
                    return;
                }
                DevicePanel.this.updateClientCombo();
                Object sel = DevicePanel.this.myDeviceCombo.getSelectedItem();
                IDevice device = sel instanceof IDevice ? (IDevice)sel : null;
                DevicePanel.this.myDeviceContext.fireDeviceSelected(device);
            }
        });
        this.myDeviceCombo.setRenderer(new DeviceRenderer.DeviceComboBoxRenderer("No Connected Devices"));
        Dimension size = this.myDeviceCombo.getMinimumSize();
        this.myDeviceCombo.setMinimumSize(new Dimension(200, size.height));
    }

    private void initializeClientCombo() {
        this.myClientCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicePanel.this.myIgnoreActionEvents) {
                    return;
                }
                Client client = (Client)DevicePanel.this.myClientCombo.getSelectedItem();
                if (client != null) {
                    DevicePanel.this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
                }
                DevicePanel.this.myDeviceContext.fireClientSelected(client);
            }
        });
        this.myClientCombo.setRenderer(new ClientCellRenderer("No Debuggable Applications"));
        Dimension size = this.myClientCombo.getMinimumSize();
        this.myClientCombo.setMinimumSize(new Dimension(250, size.height));
    }

    public void selectDevice(IDevice device) {
        this.myDeviceCombo.setSelectedItem(device);
    }

    public void selectClient(Client client) {
        this.myClientCombo.setSelectedItem(client);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            this.myBridge = null;
        }
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void bridgeChanged(final AndroidDebugBridge bridge) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.myBridge = bridge;
                DevicePanel.this.updateDeviceCombo();
            }
        });
    }

    public void deviceConnected(IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.updateDeviceCombo();
            }
        });
    }

    public void deviceDisconnected(IDevice device) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DevicePanel.this.updateDeviceCombo();
            }
        });
    }

    public void deviceChanged(final IDevice device, final int changeMask) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((changeMask & 2) != 0) {
                    DevicePanel.this.updateClientCombo();
                } else if ((changeMask & 1) != 0) {
                    DevicePanel.this.updateDeviceCombo();
                }
                if (device != null) {
                    DevicePanel.this.myDeviceContext.fireDeviceChanged(device, changeMask);
                }
            }
        });
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DevicePanel.this.updateClientCombo();
                }
            });
        }
    }

    private void updateDeviceCombo() {
        this.myIgnoreActionEvents = true;
        boolean update = true;
        IDevice selected = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        boolean shouldAddSelected = true;
        if (this.myBridge != null) {
            for (IDevice device : this.myBridge.getDevices()) {
                boolean isSelectedReattached;
                this.myDeviceCombo.addItem(device);
                boolean bl = isSelectedReattached = selected != null && !selected.isEmulator() && selected.getSerialNumber().equals(device.getSerialNumber());
                if (selected != device && !isSelectedReattached) continue;
                this.myDeviceCombo.setSelectedItem(device);
                shouldAddSelected = false;
                update = selected != device;
            }
        }
        if (selected != null && shouldAddSelected) {
            this.myDeviceCombo.addItem(selected);
            this.myDeviceCombo.setSelectedItem(selected);
        }
        if (update) {
            this.myDeviceContext.fireDeviceSelected((IDevice)this.myDeviceCombo.getSelectedItem());
            this.updateClientCombo();
        }
        this.myIgnoreActionEvents = false;
    }

    private void updateClientCombo() {
        Client selected;
        this.myIgnoreActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client toSelect = selected = (Client)this.myClientCombo.getSelectedItem();
        boolean update = true;
        this.myClientCombo.removeAllItems();
        if (device != null) {
            Client preferredClient;
            String preferred = this.getPreferredClientForDevice(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            Client[] clients = device.getClients();
            boolean selectedClientDied = true;
            Arrays.sort(clients, new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myClientCombo.addItem(client);
                if (selected != client) continue;
                selectedClientDied = false;
            }
            if (selectedClientDied) {
                this.myClientCombo.addItem(selected);
            }
            this.myClientCombo.setSelectedItem(toSelect);
            update = toSelect != selected;
        }
        this.myIgnoreActionEvents = false;
        if (update) {
            this.myDeviceContext.fireClientSelected((Client)this.myClientCombo.getSelectedItem());
        }
    }

    @Nullable
    private String getPreferredClientForDevice(String deviceName) {
        String client = this.myPreferredClients.get(deviceName);
        return client == null ? this.myCandidateClientName : client;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myClientCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(27, 11), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

