/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsRenderer {
    @NotNull
    public static Result render(@Nullable ResourceIdResolver resolver, @NotNull PsiAnnotation annotation, int value) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
        }
        String qualifiedName = AnnotationsRenderer.getQualifiedName(annotation);
        if (qualifiedName == null) {
            Result result = AnnotationsRenderer.renderUnknown(null, value);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
            }
            return result;
        }
        if ("android.support.annotation.ColorInt".equals(qualifiedName)) {
            Result result = AnnotationsRenderer.renderColorInt(value);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
            }
            return result;
        }
        if (qualifiedName.endsWith("Res")) {
            Result result = AnnotationsRenderer.renderResourceRefAnnotation(resolver, value, qualifiedName);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
            }
            return result;
        }
        if (qualifiedName.equals("android.support.annotation.IntDef")) {
            Result result = AnnotationsRenderer.renderIntDefAnnotation(annotation, value);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
            }
            return result;
        }
        Result result = AnnotationsRenderer.renderUnknown(qualifiedName, value);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "render"));
        }
        return result;
    }

    @NotNull
    private static Result renderIntDefAnnotation(final @NotNull PsiAnnotation annotation, int value) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/android/tools/idea/debug/AnnotationsRenderer", "renderIntDefAnnotation"));
        }
        final AtomicReference valuesRef = Atomics.newReference();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                valuesRef.set(AndroidResolveHelper.resolveIntDef(annotation));
            }
        });
        AndroidResolveHelper.IntDefResolution intDef = (AndroidResolveHelper.IntDefResolution)valuesRef.get();
        if (intDef.valuesMap == null) {
            AnnotationsRenderer.renderUnknown("IntDef", value);
        }
        Result result = new Result(String.format(Locale.US, "0x%1$08x {%2$s}", value, AnnotationsRenderer.renderIntDef(value, intDef)), null);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderIntDefAnnotation"));
        }
        return result;
    }

    @NotNull
    static String renderIntDef(int value, AndroidResolveHelper.IntDefResolution intDef) {
        if (intDef.valuesMap == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderIntDef"));
            }
            return "";
        }
        if (!intDef.canBeOred) {
            String name = intDef.valuesMap.get(value);
            String string = StringUtil.notNullize((String)name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderIntDef"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(20);
        for (Map.Entry<Integer, String> entry : intDef.valuesMap.entrySet()) {
            int key = entry.getKey();
            if ((value & key) == 0) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(entry.getValue());
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderIntDef"));
        }
        return string;
    }

    @NotNull
    private static Result renderResourceRefAnnotation(@Nullable ResourceIdResolver resolver, int value, String qualifiedName) {
        String androidRes = null;
        if (resolver != null) {
            androidRes = resolver.getAndroidResourceName(value);
        }
        if (androidRes == null) {
            Result result = AnnotationsRenderer.renderUnknown(qualifiedName, value);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderResourceRefAnnotation"));
            }
            return result;
        }
        String result = String.format(Locale.US, "0x%1$08x {%2$s}", value, androidRes);
        Result result2 = new Result(result, null);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderResourceRefAnnotation"));
        }
        return result2;
    }

    @NotNull
    private static Result renderColorInt(int value) {
        int alpha = value >>> 24;
        boolean hasAlpha = alpha != 0;
        Color color = new Color(value, hasAlpha);
        String result = String.format(Locale.US, "0x%1$08x {a=%2$02d r=%3$02d g=%4$02d b=%5$02d}", value, color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        Result result2 = new Result(result, (Icon)new ColorIcon(16, 12, color, true));
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderColorInt"));
        }
        return result2;
    }

    @NotNull
    private static Result renderUnknown(@Nullable String annotationName, int value) {
        Result result = new Result(String.format("0x%1$08x {@%2$s ?}", value, annotationName == null ? "" : AnnotationsRenderer.getSimpleClassName(annotationName)), null);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/AnnotationsRenderer", "renderUnknown"));
        }
        return result;
    }

    @Nullable
    private static String getQualifiedName(final PsiAnnotation annotation) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annotation.getQualifiedName();
            }
        });
    }

    private static String getSimpleClassName(@NotNull String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/debug/AnnotationsRenderer", "getSimpleClassName"));
        }
        int index = fqcn.lastIndexOf(46);
        return index < fqcn.length() - 1 ? fqcn.substring(index + 1) : fqcn;
    }

    public static class Result {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public Result(@NotNull String label, @Nullable Icon icon) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/debug/AnnotationsRenderer$Result", "<init>"));
            }
            this.label = label;
            this.icon = icon;
        }
    }
}

