/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.tools.idea.editors.navigation.model.ReflectiveHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLReader {
    private final InputStream in;

    public XMLReader(InputStream in) {
        this.in = in;
    }

    public Object read() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            org.xml.sax.XMLReader reader = parser.getXMLReader();
            ErrorHandler errorHandler = reader.getErrorHandler();
            if (errorHandler == null) {
                errorHandler = new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException e) throws SAXException {
                        System.err.println("Warning, line " + e.getLineNumber() + ": " + e);
                    }

                    @Override
                    public void error(SAXParseException e) throws SAXException {
                        System.err.print("Error on line " + e.getLineNumber());
                        throw new SAXException(e);
                    }

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        System.err.print("Fatal error on line " + e.getLineNumber());
                        throw new SAXException(e);
                    }
                };
            }
            ReflectiveHandler handler = new ReflectiveHandler(errorHandler);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(this.in));
            return handler.result;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

