/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifierUtils {
    private static final Logger LOG = Logger.getInstance(QualifierUtils.class);
    static final ImmutableMap<Class<? extends ResourceQualifier>, Class<? extends Enum>> ENUM_QUALIFIERS_MAPPING = ImmutableMap.builder().put(NightModeQualifier.class, NightMode.class).put(KeyboardStateQualifier.class, KeyboardState.class).put(ScreenSizeQualifier.class, ScreenSize.class).put(NavigationStateQualifier.class, NavigationState.class).put(ScreenOrientationQualifier.class, ScreenOrientation.class).put(LayoutDirectionQualifier.class, LayoutDirection.class).put(TouchScreenQualifier.class, TouchScreen.class).put(NavigationMethodQualifier.class, Navigation.class).put(UiModeQualifier.class, UiMode.class).put(TextInputMethodQualifier.class, Keyboard.class).put(ScreenRatioQualifier.class, ScreenRatio.class).put(ScreenRoundQualifier.class, ScreenRound.class).build();

    @Nullable(value="if all the values are contained in the set")
    private static <T extends Enum<T>> T findIncompatibleEnumValue(EnumSet<T> currentValues) {
        EnumSet<T> complement = EnumSet.complementOf(currentValues);
        return (T)((Enum)Iterables.getFirst(complement, null));
    }

    private static <E extends Enum<E>, Q extends ResourceQualifier> ResourceQualifier getIncompatibleEnum(Class<E> enumType, Class<Q> resourceQualifierType, Collection<ResourceQualifier> resourceQualifiers) {
        Method getValueMethod;
        ArrayList currentValues = Lists.newArrayList();
        try {
            getValueMethod = resourceQualifierType.getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("getValue method not found on the qualifier type (not an enum qualifier)", (Throwable)e);
            return null;
        }
        for (ResourceQualifier qualifier : resourceQualifiers) {
            if (qualifier.getClass() != resourceQualifierType) {
                LOG.error(String.format("The passed list of qualifiers of type '$1%s' doesn't match the passed type '$2%s", qualifier.getClass().getSimpleName(), resourceQualifierType.getSimpleName()));
                return null;
            }
            ResourceQualifier enumQualifier = qualifier;
            try {
                currentValues.add((Enum)getValueMethod.invoke((Object)enumQualifier, new Object[0]));
            }
            catch (IllegalAccessException e) {
                LOG.error("getValue method is not public", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("InvocationTargetException", (Throwable)e);
            }
        }
        Object incompatibleEnumValue = QualifierUtils.findIncompatibleEnumValue(EnumSet.copyOf(currentValues));
        if (incompatibleEnumValue == null) {
            return null;
        }
        try {
            Constructor<Q> constructor = resourceQualifierType.getConstructor(enumType);
            return (ResourceQualifier)constructor.newInstance(incompatibleEnumValue);
        }
        catch (NoSuchMethodException e) {
            LOG.error("The qualifier type does not have a constructor with the passed enum type", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error calling qualifier constructor", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error("Error calling qualifier constructor", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error calling qualifier constructor", (Throwable)e);
        }
        return null;
    }

    private static ResourceQualifier getIncompatibleVersionQualifier(@NotNull Collection<ResourceQualifier> qualifiers) {
        if (qualifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiers", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getIncompatibleVersionQualifier"));
        }
        assert (!qualifiers.isEmpty());
        int minApiLevel = Integer.MAX_VALUE;
        for (ResourceQualifier qualifier : qualifiers) {
            VersionQualifier versionQualifier = (VersionQualifier)qualifier;
            minApiLevel = Math.min(versionQualifier.getVersion(), minApiLevel);
        }
        return new VersionQualifier(minApiLevel - 1);
    }

    static ResourceQualifier getIncompatibleDensityQualifier(@NotNull Collection<ResourceQualifier> qualifiers) {
        if (qualifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiers", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getIncompatibleDensityQualifier"));
        }
        Density minDensity = null;
        for (ResourceQualifier qualifier : qualifiers) {
            DensityQualifier densityQualifier = (DensityQualifier)qualifier;
            Density value = densityQualifier.getValue();
            if (minDensity != null && value.getDpiValue() >= minDensity.getDpiValue()) continue;
            minDensity = value;
        }
        if (minDensity == null || minDensity == Density.NODPI) {
            return null;
        }
        Density lowerDensity = Density.NODPI;
        for (Density value : Density.values()) {
            if (value.getDpiValue() <= lowerDensity.getDpiValue() || value.getDpiValue() >= minDensity.getDpiValue()) continue;
            lowerDensity = value;
        }
        return new DensityQualifier(lowerDensity);
    }

    private static ResourceQualifier getIncompatibleQualifier(@NotNull Collection<ResourceQualifier> qualifiers) {
        if (qualifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiers", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getIncompatibleQualifier"));
        }
        assert (!qualifiers.isEmpty());
        Class<?> type = qualifiers.iterator().next().getClass();
        for (ResourceQualifier qualifier : qualifiers) {
            assert (type == qualifier.getClass());
        }
        if (type == VersionQualifier.class) {
            return QualifierUtils.getIncompatibleVersionQualifier(qualifiers);
        }
        if (type == LocaleQualifier.class) {
            return new LocaleQualifier("__");
        }
        if (type == DensityQualifier.class) {
            return QualifierUtils.getIncompatibleDensityQualifier(qualifiers);
        }
        if (ENUM_QUALIFIERS_MAPPING.containsKey(type)) {
            Class enumType = (Class)ENUM_QUALIFIERS_MAPPING.get(type);
            return QualifierUtils.getIncompatibleEnum(enumType, type, qualifiers);
        }
        return null;
    }

    @Nullable(value="if there is no configuration that matches the constraints")
    public static <T> FolderConfiguration restrictConfiguration(@NotNull ConfiguredElement<T> compatible, Collection<ConfiguredElement<T>> allItems) {
        if (compatible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatible", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "restrictConfiguration"));
        }
        ArrayList incompatibleConfigurations = Lists.newArrayListWithCapacity((int)allItems.size());
        boolean found = false;
        for (ConfiguredElement<T> configuredItem : allItems) {
            FolderConfiguration configuration = configuredItem.getConfiguration();
            if (configuredItem.equals(compatible)) {
                found = true;
                continue;
            }
            incompatibleConfigurations.add(configuration);
        }
        assert (found);
        return QualifierUtils.restrictConfiguration(compatible.getConfiguration(), incompatibleConfigurations);
    }

    @Nullable(value="if there is no configuration that matches the constraints")
    public static FolderConfiguration restrictConfiguration(@NotNull FolderConfiguration compatible, @NotNull Collection<FolderConfiguration> incompatibles) {
        if (compatible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatible", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "restrictConfiguration"));
        }
        if (incompatibles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibles", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "restrictConfiguration"));
        }
        ArrayList matchingIncompatibles = Lists.newArrayList();
        for (FolderConfiguration incompatible : incompatibles) {
            if (!incompatible.isMatchFor(compatible)) continue;
            matchingIncompatibles.add(incompatible);
        }
        if (matchingIncompatibles.isEmpty()) {
            return compatible;
        }
        FolderConfiguration restrictedConfiguration = FolderConfiguration.copyOf((FolderConfiguration)compatible);
        for (int qualifierIndex = 0; qualifierIndex < FolderConfiguration.getQualifierCount(); ++qualifierIndex) {
            ResourceQualifier compatibleQualifier = compatible.getQualifier(qualifierIndex);
            if (compatibleQualifier == null) {
                ArrayList incompatibleQualifiers = Lists.newArrayList();
                for (FolderConfiguration incompatible : matchingIncompatibles) {
                    ResourceQualifier incompatibleQualifier = incompatible.getQualifier(qualifierIndex);
                    if (incompatibleQualifier == null) continue;
                    incompatibleQualifiers.add(incompatibleQualifier);
                }
                if (incompatibleQualifiers.isEmpty()) continue;
                ResourceQualifier qualifier = QualifierUtils.getIncompatibleQualifier(incompatibleQualifiers);
                if (qualifier == null) {
                    return null;
                }
                restrictedConfiguration.addQualifier(qualifier);
            }
            Iterator matchingIterator = matchingIncompatibles.iterator();
            while (matchingIterator.hasNext()) {
                ResourceQualifier incompatibleQualifier = ((FolderConfiguration)matchingIterator.next()).getQualifier(qualifierIndex);
                if (compatibleQualifier != null && !compatibleQualifier.equals((Object)incompatibleQualifier)) {
                    matchingIterator.remove();
                    continue;
                }
                if (compatibleQualifier != null || incompatibleQualifier == null) continue;
                assert (!incompatibleQualifier.isMatchFor(restrictedConfiguration.getQualifier(qualifierIndex)));
                matchingIterator.remove();
            }
            if (!matchingIncompatibles.isEmpty()) continue;
            return restrictedConfiguration;
        }
        return null;
    }
}

