/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, @NotNull JavaParameters javaParameters) {
        if (javaParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParameters", "com/android/tools/idea/gradle/AndroidJunitPatcher", "patchJavaParameters"));
        }
        if (module == null || !Projects.isBuildWithGradle(module.getProject())) {
            return;
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
        if (androidModel == null) {
            return;
        }
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifactInSelectedVariant();
        if (testArtifact == null || !(testArtifact instanceof JavaArtifact) || !"_unit_test_".equals(testArtifact.getName())) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return;
        }
        String originalClassPath = classPath.getPathsString();
        try {
            AndroidJunitPatcher.handlePlatformJar(classPath, platform, (JavaArtifact)testArtifact);
            AndroidJunitPatcher.handleJavaResources(module, androidModel, classPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Error patching the JUnit class path. Original class path:%n%s", originalClassPath), e);
        }
    }

    private static void handlePlatformJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull JavaArtifact artifact) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        String androidJarPath = platform.getTarget().getPath(1);
        for (Object entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove((String)entry);
        }
        List mockableJars = ContainerUtil.newSmartList();
        for (String path : classPath.getPathList()) {
            if (!new File(FileUtil.toSystemDependentName((String)path)).getName().startsWith("mockable-")) continue;
            mockableJars.add(path);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = AndroidJunitPatcher.getMockableJarFromModel(artifact);
        if (mockableJar != null) {
            classPath.addTail(mockableJar.getPath());
        } else {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
        }
    }

    @Nullable
    private static File getMockableJarFromModel(@NotNull JavaArtifact model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/AndroidJunitPatcher", "getMockableJarFromModel"));
        }
        try {
            return model.getMockablePlatformJar();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    private static void handleJavaResources(@NotNull Module module, @NotNull AndroidGradleModel androidModel, @NotNull PathsList classPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handleJavaResources"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handleJavaResources"));
        }
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handleJavaResources"));
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        CompileScope scope = compilerManager.createModulesCompileScope(new Module[]{module}, true, true);
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifactInSelectedVariant();
        if (testArtifact != null) {
            try {
                classPath.add(testArtifact.getJavaResourcesFolder());
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
        for (Module affectedModule : scope.getAffectedModules()) {
            AndroidGradleModel affectedAndroidModel;
            AndroidFacet facet = AndroidFacet.getInstance(affectedModule);
            if (facet == null || (affectedAndroidModel = AndroidGradleModel.get(facet)) == null) continue;
            try {
                classPath.add(affectedAndroidModel.getMainArtifact().getJavaResourcesFolder());
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
    }
}

