/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ModuleDependency;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class Dependency
extends GradleDslElement {
    @NotNull
    private final Dependencies myParent;
    @NotNull
    private final GrMethodCall myMethodCall;
    @NotNull
    private final String myConfigurationName;

    protected Dependency(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "<init>"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "<init>"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "<init>"));
        }
        super(parent, null, configurationName);
        this.myParent = parent;
        this.myMethodCall = methodCall;
        this.myConfigurationName = configurationName;
    }

    @NotNull
    public String configurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "configurationName"));
        }
        return string;
    }

    @NotNull
    protected Dependencies getParent() {
        Dependencies dependencies = this.myParent;
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "getParent"));
        }
        return dependencies;
    }

    @NotNull
    protected GrMethodCall getMethodCall() {
        GrMethodCall grMethodCall = this.myMethodCall;
        if (grMethodCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "getMethodCall"));
        }
        return grMethodCall;
    }

    protected void removeFromParent() {
        GrClosableBlock closureBlock = this.myParent.getClosureBlock();
        assert (closureBlock != null);
        closureBlock.removeElements(new PsiElement[]{this.myMethodCall});
    }

    @NotNull
    static List<Dependency> parse(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        if (methodCall instanceof GrMethodCallExpression) {
            List<Dependency> list = ExternalDependency.parse(parent, (GrMethodCallExpression)methodCall);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
            }
            return list;
        }
        if (methodCall instanceof GrApplicationStatement) {
            List<Dependency> list = Dependency.parse(parent, (GrApplicationStatement)methodCall);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
            }
            return list;
        }
        List<Dependency> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        return list;
    }

    @NotNull
    private static List<Dependency> parse(@NotNull Dependencies parent, @NotNull GrApplicationStatement statement) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        GrReferenceExpression configurationNameExpression = Dependency.findValidConfigurationNameExpression((GrMethodCall)statement);
        if (configurationNameExpression == null) {
            List<Dependency> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
            }
            return list;
        }
        GrCommandArgumentList argumentList = statement.getArgumentList();
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        List<Dependency> dependencies = ExternalDependency.parse(parent, (GrMethodCall)statement, configurationNameExpression, arguments);
        if (!dependencies.isEmpty()) {
            List<Dependency> list = dependencies;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
            }
            return list;
        }
        int argumentCount = arguments.length;
        if (argumentCount == 0) {
            List<Dependency> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
            }
            return list;
        }
        GroovyPsiElement first = arguments[0];
        if (first instanceof GrMethodCallExpression) {
            Dependency dependency;
            GrMethodCallExpression expression = (GrMethodCallExpression)first;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, GrReferenceExpression.class);
            if (referenceExpression == null) {
                List<Dependency> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
                }
                return list;
            }
            String referenceName = referenceExpression.getText();
            if ("project".equals(referenceName) && (dependency = Dependency.parseModuleDependency(parent, (GrMethodCall)statement, configurationNameExpression.getText(), (GrMethodCallExpression)first)) != null) {
                List<Dependency> list = Collections.singletonList(dependency);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
                }
                return list;
            }
        }
        List<Dependency> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parse"));
        }
        return list;
    }

    @Nullable
    protected static GrReferenceExpression findValidConfigurationNameExpression(@NotNull GrMethodCall methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "findValidConfigurationNameExpression"));
        }
        GrReferenceExpression found = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)methodCall, GrReferenceExpression.class);
        if (found != null && StringUtil.isNotEmpty((String)found.getText())) {
            return found;
        }
        return null;
    }

    @Nullable
    private static Dependency parseModuleDependency(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull GrMethodCallExpression expression) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parseModuleDependency"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parseModuleDependency"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parseModuleDependency"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/idea/gradle/dsl/dependencies/Dependency", "parseModuleDependency"));
        }
        GrArgumentList argumentList = expression.getArgumentList();
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 1 && arguments[0] instanceof GrLiteral) {
            GrLiteral literal = (GrLiteral)arguments[0];
            ModuleDependency moduleDependency = ModuleDependency.withCompactNotation(parent, methodCall, configurationName, literal);
            if (moduleDependency != null) {
                return moduleDependency;
            }
            return null;
        }
        ModuleDependency moduleDependency = ModuleDependency.withMapNotation(parent, methodCall, configurationName, argumentList);
        if (moduleDependency != null) {
            return moduleDependency;
        }
        return null;
    }
}

