/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ModuleDependency
extends Dependency {
    @NotNull
    GrLiteral myPathLiteral;
    @Nullable
    GrLiteral myConfigurationLiteral;
    @Nullable
    private String myNewName;

    @Nullable
    public static ModuleDependency withCompactNotation(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull GrLiteral pathLiteral) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withCompactNotation"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withCompactNotation"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withCompactNotation"));
        }
        if (pathLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathLiteral", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withCompactNotation"));
        }
        if (StringUtil.isEmpty((String)PsiElements.getUnquotedText(pathLiteral))) {
            return null;
        }
        return new ModuleDependency(parent, methodCall, configurationName, pathLiteral, null);
    }

    @Nullable
    public static ModuleDependency withMapNotation(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull GrArgumentList argumentList) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withMapNotation"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withMapNotation"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withMapNotation"));
        }
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "withMapNotation"));
        }
        GrLiteral pathLiteral = ModuleDependency.findNamedArgumentLiteralValue(argumentList, "path");
        if (pathLiteral == null || StringUtil.isEmpty((String)PsiElements.getUnquotedText(pathLiteral))) {
            return null;
        }
        return new ModuleDependency(parent, methodCall, configurationName, pathLiteral, ModuleDependency.findNamedArgumentLiteralValue(argumentList, "configuration"));
    }

    @Nullable
    private static GrLiteral findNamedArgumentLiteralValue(@NotNull GrArgumentList argumentList, @NotNull String label) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "findNamedArgumentLiteralValue"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "findNamedArgumentLiteralValue"));
        }
        GrNamedArgument namedArgument = argumentList.findNamedArgument(label);
        if (namedArgument == null) {
            return null;
        }
        if (namedArgument.getExpression() instanceof GrLiteral) {
            return (GrLiteral)namedArgument.getExpression();
        }
        return null;
    }

    private ModuleDependency(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull GrLiteral pathLiteral, @Nullable GrLiteral configurationLiteral) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "<init>"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "<init>"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "<init>"));
        }
        if (pathLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathLiteral", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "<init>"));
        }
        super(parent, methodCall, configurationName);
        this.myPathLiteral = pathLiteral;
        this.myConfigurationLiteral = configurationLiteral;
    }

    @NotNull
    public String getPath() {
        String string = StringUtil.notNullize((String)PsiElements.getUnquotedText(this.myPathLiteral));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.getPath());
        int segmentCount = pathSegments.size();
        String string = segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "getName"));
        }
        return string;
    }

    @Nullable
    public String getTargetConfiguration() {
        if (this.myConfigurationLiteral == null) {
            return null;
        }
        return PsiElements.getUnquotedText(this.myConfigurationLiteral);
    }

    public void setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "setName"));
        }
        this.myNewName = newName;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        this.applyNameChange();
    }

    private void applyNameChange() {
        String newPath;
        if (this.myNewName == null) {
            return;
        }
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.getPath());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + this.myNewName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, this.myNewName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        this.myPathLiteral = PsiElements.setLiteralText(this.myPathLiteral, newPath);
        this.reset();
    }

    @Override
    protected void reset() {
        this.myNewName = null;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/ModuleDependency", "getChildren"));
        }
        return immutableList;
    }
}

