/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Message {
    @NotNull
    private final String myGroupName;
    @NotNull
    private final Type myType;
    @NotNull
    private final String[] myText;
    @NotNull
    private final Navigatable myNavigatable;
    @Nullable
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public Message(@NotNull String groupName, @NotNull Type type, String ... text) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        this(groupName, type, NonNavigatable.INSTANCE, text);
    }

    public Message(@NotNull Project project, @NotNull String groupName, @NotNull Type type, @NotNull VirtualFile file, int line, int column, String ... text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        this(groupName, type, (Navigatable)new OpenFileDescriptor(project, file, line, column), file, line, column, text);
    }

    public Message(@NotNull String groupName, @NotNull Type type, @NotNull Navigatable navigatable, String ... text) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        this(groupName, type, navigatable, null, -1, -1, text);
    }

    private Message(@NotNull String groupName, @NotNull Type type, @NotNull Navigatable navigatable, @Nullable VirtualFile file, int line, int column, String ... text) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/messages/Message", "<init>"));
        }
        this.myType = type;
        this.myText = text;
        this.myGroupName = groupName;
        this.myNavigatable = navigatable;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
    }

    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/Message", "getGroupName"));
        }
        return string;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/Message", "getType"));
        }
        return type;
    }

    @NotNull
    public String[] getText() {
        if (this.myText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/Message", "getText"));
        }
        return this.myText;
    }

    @NotNull
    public Navigatable getNavigatable() {
        Navigatable navigatable = this.myNavigatable;
        if (navigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/Message", "getNavigatable"));
        }
        return navigatable;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public static enum Type {
        ERROR(4),
        INFO(3),
        SIMPLE(1),
        WARNING(5);

        private final int myValue;

        private Type(int value) {
            this.myValue = value;
        }

        public int getValue() {
            return this.myValue;
        }

        @Nullable
        public static Type find(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/messages/Message$Type", "find"));
            }
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

