/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull ContentEntry[] contentEntries) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/FilePaths", "findParentContentEntry"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/util/FilePaths", "findParentContentEntry"));
        }
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull Collection<ContentEntry> contentEntries) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/FilePaths", "findParentContentEntry"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/util/FilePaths", "findParentContentEntry"));
        }
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        File rootFilePath;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/FilePaths", "isPathInContentEntry"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/android/tools/idea/gradle/util/FilePaths", "isPathInContentEntry"));
        }
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            rootFilePath = new File(s);
        } else {
            rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        }
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/FilePaths", "pathToIdeaUrl"));
        }
        String string = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.getPath()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/FilePaths", "pathToIdeaUrl"));
        }
        return string;
    }
}

